/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jspeditor.editors.JSPSourceEditor;

public class JSPDirectiveAssistProcessor
implements IContentAssistProcessor {
    private Image tagImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
    private Image attrImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_attribute");
    private Image valueImage = HTMLPlugin.getDefault().getImageRegistry().get("_icon_value");
    private IFile file;
    private static final String[] DIRECTIVES = new String[]{"include", "page", "taglib"};
    private static final Map ATTRIBUTES = new HashMap();

    static {
        ATTRIBUTES.put("include", new String[]{"file"});
        ATTRIBUTES.put("page", new String[]{"language", "extends", "import", "session", "buffer", "autoFlush", "isThreadSafe", "info", "errorPage", "isErrorPage", "contentType", "pageEncoding"});
        ATTRIBUTES.put("taglib", new String[]{"prefix", "tagdir", "uri"});
    }

    public void update(JSPSourceEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)input).getFile();
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String text = viewer.getDocument().get().substring(0, offset);
        int flag = 0;
        StringBuffer sb = new StringBuffer();
        String directive = "";
        String attrName = "";
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '<') {
                directive = "";
                flag = 1;
            } else if (flag == 1 && c == '%') {
                flag = 2;
            } else if (flag == 2 && c == '@') {
                flag = 3;
            } else if (flag == 3 && c == '%') {
                sb.setLength(0);
                flag = 0;
            } else if (flag == 3 && (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '=')) {
                if (directive.equals("")) {
                    directive = sb.toString().trim();
                } else {
                    attrName = sb.toString().trim();
                    if (!attrName.equals("")) {
                        flag = 4;
                    }
                }
                sb.setLength(0);
            } else if (flag == 4 && c == '\"') {
                sb.append(c);
                flag = 5;
            } else if (flag == 5 && c == '\"') {
                sb.setLength(0);
                flag = 3;
            } else if (flag == 3 || flag == 5) {
                sb.append(c);
            }
            ++i;
        }
        String lastWord = sb.toString().trim();
        if (directive.equals("")) {
            return this.getDirectives(lastWord, offset);
        }
        if (directive.equals("page") && attrName.equals("import") && lastWord.startsWith("\"")) {
            return this.getImportValues(lastWord, offset);
        }
        if (lastWord.startsWith("\"")) {
            return this.getAttributeValues(directive, attrName, lastWord, offset);
        }
        return this.getAttributes(directive, lastWord, offset);
    }

    private ICompletionProposal[] getImportValues(String lastWord, int offset) {
        try {
            if (this.file != null) {
                IJavaProject project = JavaCore.create((IProject)this.file.getProject());
                CompletionProposalCollector collector = new CompletionProposalCollector(project);
                ICompilationUnit unit = HTMLUtil.getTemporaryCompilationUnit(project);
                String matchString = lastWord.replaceFirst("^\"", "");
                String value = "import " + matchString;
                HTMLUtil.setContentsToCU(unit, value);
                unit.codeComplete(value.length(), (CompletionRequestor)collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                IJavaCompletionProposal[] proposals = collector.getJavaCompletionProposals();
                ArrayList<AbstractJavaCompletionProposal> result = new ArrayList<AbstractJavaCompletionProposal>();
                int i = 0;
                while (i < proposals.length) {
                    if (proposals[i] instanceof AbstractJavaCompletionProposal) {
                        AbstractJavaCompletionProposal proposal = (AbstractJavaCompletionProposal)proposals[i];
                        proposal.setReplacementOffset(offset - matchString.length());
                        proposal.setReplacementLength(matchString.length());
                        proposal.setReplacementString(proposal.getReplacementString().replaceFirst(";$", ""));
                        proposal.setCursorPosition(proposal.getReplacementString().length());
                        result.add(proposal);
                    }
                    ++i;
                }
                return result.toArray(new ICompletionProposal[result.size()]);
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] getAttributeValues(String directive, String attr, String lastWord, int offset) {
        ArrayList<String> values = new ArrayList<String>();
        if (directive.equals("page") && (attr.equals("autoFlush") || attr.equals("session") || attr.equals("isThreadSafe") || attr.equals("isErrorPage"))) {
            values.add("true");
            values.add("false");
        }
        if (directive.equals("taglib") && attr.equals("uri")) {
            Map innerTLD = HTMLPlugin.getInnerTLD();
            Iterator ite = innerTLD.keySet().iterator();
            while (ite.hasNext()) {
                values.add((String)ite.next());
            }
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            String[] uri = store.getString("__pref_tld_uri").split("\n");
            int i = 0;
            while (i < uri.length) {
                values.add(uri[i]);
                ++i;
            }
        }
        lastWord = lastWord.substring(1);
        ArrayList<CompletionProposal> assistInfos = new ArrayList<CompletionProposal>();
        int i = 0;
        while (i < values.size()) {
            String value = (String)values.get(i);
            if (value.startsWith(lastWord)) {
                assistInfos.add(new CompletionProposal(value, offset - lastWord.length(), lastWord.length(), value.length(), this.valueImage, value, null, null));
            }
            ++i;
        }
        return assistInfos.toArray(new ICompletionProposal[assistInfos.size()]);
    }

    private ICompletionProposal[] getDirectives(String lastWord, int offset) {
        ArrayList<CompletionProposal> assistInfos = new ArrayList<CompletionProposal>();
        int i = 0;
        while (i < DIRECTIVES.length) {
            String directive = DIRECTIVES[i];
            if (directive.startsWith(lastWord)) {
                assistInfos.add(new CompletionProposal(directive, offset - lastWord.length(), lastWord.length(), directive.length(), this.tagImage, directive, null, null));
            }
            ++i;
        }
        return assistInfos.toArray(new ICompletionProposal[assistInfos.size()]);
    }

    private ICompletionProposal[] getAttributes(String directive, String lastWord, int offset) {
        String[] attrs = (String[])ATTRIBUTES.get(directive);
        if (attrs == null) {
            return new ICompletionProposal[0];
        }
        ArrayList<CompletionProposal> assistInfos = new ArrayList<CompletionProposal>();
        int i = 0;
        while (i < attrs.length) {
            String attrName = attrs[i];
            String replace = String.valueOf(attrName) + "=\"\"";
            if (attrName.startsWith(lastWord)) {
                assistInfos.add(new CompletionProposal(replace, offset - lastWord.length(), lastWord.length(), replace.length() - 1, this.attrImage, attrName, null, null));
            }
            ++i;
        }
        return assistInfos.toArray(new ICompletionProposal[assistInfos.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ContextInformation[] info = new ContextInformation[]{};
        return info;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public String getErrorMessage() {
        return "Error";
    }
}

