/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.editors.HTMLHyperlinkInfo;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class ClassNameHyperLinkProvider
implements IHyperlinkProvider {
    private XMLEditor editor;

    public void setEditor(XMLEditor editor) {
        this.editor = editor;
    }

    public HTMLHyperlinkInfo getHyperlinkInfo(IFile file, FuzzyXMLDocument doc, FuzzyXMLElement element, String attrName, String attrValue, int offset) {
        if (file == null || this.editor == null) {
            return null;
        }
        IProject project = file.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        String[] attrNames = this.editor.getClassNameAttributes();
        int i = 0;
        while (i < attrNames.length) {
            IType type;
            if (attrName.equals(attrNames[i]) && (type = this.findType(javaProject, attrValue)) != null) {
                HTMLHyperlinkInfo info = new HTMLHyperlinkInfo();
                info.setObject(type);
                info.setOffset(0);
                info.setLength(attrValue.length());
                return info;
            }
            ++i;
        }
        return null;
    }

    private IType findType(IJavaProject project, String value) {
        try {
            IType type = project.findType(value);
            return type;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

