/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.html.HtmlMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;

public abstract class HtmlMessageRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_impl$renderkit$html$HtmlMessageRendererBase == null ? (class$org$apache$myfaces$shared_impl$renderkit$html$HtmlMessageRendererBase = HtmlMessageRendererBase.class$("org.apache.myfaces.shared_impl.renderkit.html.HtmlMessageRendererBase")) : class$org$apache$myfaces$shared_impl$renderkit$html$HtmlMessageRendererBase));
    static /* synthetic */ Class class$org$apache$myfaces$shared_impl$renderkit$html$HtmlMessageRendererBase;

    protected abstract String getSummary(FacesContext var1, UIComponent var2, FacesMessage var3, String var4);

    protected abstract String getDetail(FacesContext var1, UIComponent var2, FacesMessage var3, String var4);

    protected void renderMessage(FacesContext facesContext, UIComponent message) throws IOException {
        this.renderMessage(facesContext, message, false);
    }

    protected void renderMessage(FacesContext facesContext, UIComponent message, boolean alwaysRenderSpan) throws IOException {
        String forAttr = this.getFor(message);
        if (forAttr == null) {
            log.error((Object)"Attribute 'for' of UIMessage must not be null");
            return;
        }
        UIComponent forComponent = message.findComponent(forAttr);
        if (forComponent == null) {
            log.error((Object)("Could not render Message. Unable to find component '" + forAttr + "' (calling findComponent on component '" + message.getClientId(facesContext) + "'). If the provided id was correct, wrap the message and its component into an h:panelGroup or h:panelGrid."));
            return;
        }
        String clientId = forComponent.getClientId(facesContext);
        Iterator messageIterator = facesContext.getMessages(clientId);
        if (!messageIterator.hasNext()) {
            if (alwaysRenderSpan) {
                ResponseWriter writer = facesContext.getResponseWriter();
                writer.startElement("span", message);
                writer.writeAttribute("id", (Object)message.getId(), null);
                writer.endElement("span");
            }
            return;
        }
        FacesMessage facesMessage = (FacesMessage)messageIterator.next();
        this.renderSingleFacesMessage(facesContext, message, facesMessage, clientId);
    }

    protected void renderSingleFacesMessage(FacesContext facesContext, UIComponent message, FacesMessage facesMessage, String messageClientId) throws IOException {
        boolean showDetail;
        String[] styleAndClass = HtmlMessageRendererBase.getStyleAndStyleClass(message, facesMessage.getSeverity());
        String style = styleAndClass[0];
        String styleClass = styleAndClass[1];
        String summary = this.getSummary(facesContext, message, facesMessage, messageClientId);
        String detail = this.getDetail(facesContext, message, facesMessage, messageClientId);
        String title = this.getTitle(message);
        boolean tooltip = this.isTooltip(message);
        if (title == null && tooltip) {
            title = summary;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean span = false;
        if (message.getId() != null && !message.getId().startsWith("_id")) {
            span = true;
            writer.startElement("span", message);
            HtmlRendererUtils.writeIdIfNecessary(writer, message, facesContext);
            HtmlRendererUtils.renderHTMLAttributes(writer, message, HTML.MESSAGE_PASSTHROUGH_ATTRIBUTES_WITHOUT_TITLE_STYLE_AND_STYLE_CLASS);
        } else {
            span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, message, "span", HTML.MESSAGE_PASSTHROUGH_ATTRIBUTES_WITHOUT_TITLE_STYLE_AND_STYLE_CLASS);
        }
        span |= HtmlRendererUtils.renderHTMLAttributeWithOptionalStartElement(writer, message, "span", "title", title, span);
        span |= HtmlRendererUtils.renderHTMLAttributeWithOptionalStartElement(writer, message, "span", "style", style, span);
        span |= HtmlRendererUtils.renderHTMLAttributeWithOptionalStartElement(writer, message, "span", "styleClass", styleClass, span);
        boolean showSummary = this.isShowSummary(message) && summary != null;
        boolean bl = showDetail = this.isShowDetail(message) && detail != null;
        if (showSummary && (title != null || !tooltip)) {
            writer.writeText((Object)summary, null);
            if (showDetail) {
                writer.writeText((Object)" ", null);
            }
        }
        if (showDetail) {
            writer.writeText((Object)detail, null);
        }
        if (span) {
            writer.endElement("span");
        }
    }

    public static String[] getStyleAndStyleClass(UIComponent message, FacesMessage.Severity severity) {
        String style = null;
        String styleClass = null;
        if (message instanceof HtmlMessage) {
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = ((HtmlMessage)message).getInfoStyle();
                styleClass = ((HtmlMessage)message).getInfoClass();
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = ((HtmlMessage)message).getWarnStyle();
                styleClass = ((HtmlMessage)message).getWarnClass();
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = ((HtmlMessage)message).getErrorStyle();
                styleClass = ((HtmlMessage)message).getErrorClass();
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = ((HtmlMessage)message).getFatalStyle();
                styleClass = ((HtmlMessage)message).getFatalClass();
            }
            if (style == null) {
                style = ((HtmlMessage)message).getStyle();
            }
            if (styleClass == null) {
                styleClass = ((HtmlMessage)message).getStyleClass();
            }
        } else {
            Map attr = message.getAttributes();
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = (String)attr.get("infoStyle");
                styleClass = (String)attr.get("infoClass");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = (String)attr.get("warnStyle");
                styleClass = (String)attr.get("warnClass");
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = (String)attr.get("errorStyle");
                styleClass = (String)attr.get("errorClass");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = (String)attr.get("fatalStyle");
                styleClass = (String)attr.get("fatalClass");
            }
            if (style == null) {
                style = (String)attr.get("styleClass");
            }
            if (styleClass == null) {
                styleClass = (String)attr.get("styleClass");
            }
        }
        return new String[]{style, styleClass};
    }

    protected String getFor(UIComponent component) {
        if (component instanceof UIMessage) {
            return ((UIMessage)component).getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    protected String getTitle(UIComponent component) {
        if (component instanceof HtmlMessage) {
            return ((HtmlMessage)component).getTitle();
        }
        return (String)component.getAttributes().get("title");
    }

    protected boolean isTooltip(UIComponent component) {
        if (component instanceof HtmlMessage) {
            return ((HtmlMessage)component).isTooltip();
        }
        return RendererUtils.getBooleanAttribute(component, "tooltip", false);
    }

    protected boolean isShowSummary(UIComponent component) {
        if (component instanceof UIMessage) {
            return ((UIMessage)component).isShowSummary();
        }
        return RendererUtils.getBooleanAttribute(component, "showSummary", false);
    }

    protected boolean isShowDetail(UIComponent component) {
        if (component instanceof UIMessage) {
            return ((UIMessage)component).isShowDetail();
        }
        return RendererUtils.getBooleanAttribute(component, "showDetail", false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

