/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class ZipUtils {
    public static final String ZIP_CHARSET = "ISO-8859-1";

    private ZipUtils() {
    }

    public static String unzipString(String s) {
        try {
            int c;
            Base64 base64Codec = new Base64();
            ByteArrayInputStream decodedStream = new ByteArrayInputStream(base64Codec.decode(s.getBytes(ZIP_CHARSET)));
            GZIPInputStream unzippedStream = new GZIPInputStream(decodedStream);
            StringBuffer buf = new StringBuffer();
            while ((c = ((InputStream)unzippedStream).read()) != -1) {
                buf.append((char)c);
            }
            ((InputStream)unzippedStream).close();
            decodedStream.close();
            return buf.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String zipString(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(baos);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zos, ZIP_CHARSET);
            writer.write(s);
            writer.close();
            ((OutputStream)zos).close();
            baos.close();
            Base64 base64Codec = new Base64();
            return new String(base64Codec.encode(baos.toByteArray()), ZIP_CHARSET);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

