/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagConverter;
import tk.eclipse.plugin.htmleditor.ICustomTagConverterContributer;
import tk.eclipse.plugin.jsf.JSFConverter;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jspeditor.converters.AbstractCustomTagConverter;
import tk.eclipse.plugin.jspeditor.converters.NullConverter;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;

public class JSFCustomTagConverterContributer
implements ICustomTagConverterContributer {
    private HashMap map = new HashMap();
    private static int SELECT_MODE_RADIO = 0;
    private static int SELECT_MODE_COMBO = 1;
    private static int SELECT_MODE_LIST = 2;
    private static int SELECT_MODE_CHECK = 3;
    private static int SELECT_MODE_COMBO_MANY = 4;
    private static int SELECT_MODE_LIST_MANY = 5;

    public JSFCustomTagConverterContributer() {
        this.map.put("view", new NullConverter());
        this.map.put("verbatim", new NullConverter());
        this.map.put("form", new JSFConverter("form"));
        this.map.put("commandButton", new JSFConverter("input type=\"submit\""));
        this.map.put("commandLink", new CommandLinkConverter());
        this.map.put("message", null);
        this.map.put("inputText", new JSFConverter("input type=\"text\""));
        this.map.put("outputText", new OutputTextConverter());
        this.map.put("inputTextarea", new JSFConverter("textarea"));
        this.map.put("inputSecret", new JSFConverter("input type=\"password\""));
        this.map.put("inputHidden", new JSFConverter("input type=\"hidden\""));
        this.map.put("outputLabel", new NullConverter());
        this.map.put("outputFormat", new JSFConverter("span"));
        this.map.put("graphicImage", new GraphicImageConverter());
        this.map.put("panelGrid", new PanelGridConverter());
        this.map.put("dataTable", new DataTableConverter());
        this.map.put("selectOneRadio", new SelectConverter(SELECT_MODE_RADIO));
        this.map.put("selectOneMenu", new SelectConverter(SELECT_MODE_COMBO));
        this.map.put("selectOneListbox", new SelectConverter(SELECT_MODE_LIST));
        this.map.put("selectBooleanCheckbox", new CheckboxConverter());
        this.map.put("selectManyCheckbox", new SelectConverter(SELECT_MODE_CHECK));
        this.map.put("selectManyMenu", new SelectConverter(SELECT_MODE_COMBO_MANY));
        this.map.put("selectManyListbox", new SelectConverter(SELECT_MODE_LIST_MANY));
        this.map.put("inputFileUpload", new JSFConverter("input type=\"file\""));
        this.map.put("inputDate", new InputDateConverter());
        this.map.put("inputCalendar", new InputCalendarConverter());
    }

    public ICustomTagConverter getConverter(String tagName) {
        return (ICustomTagConverter)this.map.get(tagName);
    }

    private class GraphicImageConverter
    extends JSFConverter {
        public GraphicImageConverter() {
            super("img");
            this.addAttributeConversion("url", "src");
        }
    }

    private class OutputTextConverter
    extends JSFConverter {
        public OutputTextConverter() {
            super("span");
        }

        protected String createTag(String tagName, Map attributes) {
            String value = (String)attributes.remove("value");
            String result = super.createTag(tagName, attributes);
            attributes.put("value", value);
            return result;
        }

        public String process(Map attrs, FuzzyXMLNode[] children, JSPInfo info) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.convertStartTag(attrs));
            sb.append(FuzzyXMLUtil.escape((String)((String)attrs.get("value")), (boolean)true));
            sb.append(this.convertEndTag());
            return sb.toString();
        }
    }

    private class CommandLinkConverter
    extends JSFConverter {
        public CommandLinkConverter() {
            super("a");
        }

        protected String createTag(String tagName, Map attributes) {
            return String.valueOf(super.createTag(tagName, attributes)) + " href=\"#\"";
        }
    }

    private class DataTableConverter
    extends JSFConverter {
        public DataTableConverter() {
            super("table");
        }

        public String process(Map attrs, FuzzyXMLNode[] children, JSPInfo info) {
            String[] dim;
            FuzzyXMLElement element;
            String name;
            StringBuffer sb = new StringBuffer();
            sb.append("<" + this.createTag("table", attrs) + ">");
            sb.append("<tr>");
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof FuzzyXMLElement && (name = (element = (FuzzyXMLElement)children[i]).getName()).indexOf(":") != -1 && (dim = name.split(":"))[1].equals("column")) {
                    sb.append("<th>");
                    sb.append(this.processHeader(element.getChildren(), info));
                    sb.append("</th>");
                }
                ++i;
            }
            sb.append("</tr>");
            sb.append("<tr>");
            i = 0;
            while (i < children.length) {
                if (children[i] instanceof FuzzyXMLElement && (name = (element = (FuzzyXMLElement)children[i]).getName()).indexOf(":") != -1 && (dim = name.split(":"))[1].equals("column")) {
                    sb.append("<td>");
                    sb.append(this.processBody(element.getChildren(), info));
                    sb.append("</td>");
                }
                ++i;
            }
            sb.append("</tr>");
            sb.append("</table>");
            return sb.toString();
        }

        private String processHeader(FuzzyXMLNode[] nodes, JSPInfo info) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < nodes.length) {
                String[] dim;
                FuzzyXMLElement element;
                String name;
                if (nodes[i] instanceof FuzzyXMLElement && (name = (element = (FuzzyXMLElement)nodes[i]).getName()).indexOf(":") != -1 && (dim = name.split(":"))[1].equals("facet")) {
                    sb.append(this.evalBody(element.getChildren(), info));
                }
                ++i;
            }
            return sb.toString();
        }

        private String processBody(FuzzyXMLNode[] nodes, JSPInfo info) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < nodes.length) {
                String[] dim;
                FuzzyXMLElement element;
                String name;
                if (nodes[i] instanceof FuzzyXMLElement && (name = (element = (FuzzyXMLElement)nodes[i]).getName()).indexOf(":") != -1 && !(dim = name.split(":"))[1].equals("facet")) {
                    sb.append(this.evalBody(new FuzzyXMLNode[]{nodes[i]}, info));
                }
                ++i;
            }
            return sb.toString();
        }
    }

    private class InputDateConverter
    extends AbstractCustomTagConverter {
        private InputDateConverter() {
        }

        public String process(Map attrs, FuzzyXMLNode[] children, JSPInfo info) {
            String type = (String)attrs.get("type");
            String popup = (String)attrs.get("popupCalendar");
            if (type == null) {
                type = "date";
            }
            if (popup == null) {
                popup = "false";
            }
            StringBuffer sb = new StringBuffer();
            if (type.equals("date") || type.equals("both")) {
                sb.append(this.createInputText(attrs, 2));
                sb.append("<select").append(this.getAttribute(attrs)).append(">");
                Calendar cal = Calendar.getInstance();
                int i = 0;
                while (i < 12) {
                    cal.set(2, i);
                    sb.append("<option>").append(Util.getMonthString(cal.getTime())).append("</option>");
                    ++i;
                }
                sb.append("</select>");
                sb.append(this.createInputText(attrs, 4));
                if (popup.equals("true")) {
                    sb.append("<input type=\"button\" value=\"...\">");
                }
            }
            if (type.equals("both")) {
                sb.append(" ");
            }
            if (type.equals("time") || type.equals("both")) {
                sb.append(this.createInputText(attrs, 2));
                sb.append(":");
                sb.append(this.createInputText(attrs, 2));
                sb.append(":");
                sb.append(this.createInputText(attrs, 2));
            }
            return sb.toString();
        }

        private String createInputText(Map attrs, int length) {
            StringBuffer sb = new StringBuffer();
            sb.append("<input type=\"text\" maxlength=\"").append(length).append("\" size=\"").append(length).append("\"");
            sb.append(this.getAttribute(attrs));
            sb.append("/>");
            return sb.toString();
        }
    }

    private class InputCalendarConverter
    extends AbstractCustomTagConverter {
        private InputCalendarConverter() {
        }

        public String process(Map attrs, FuzzyXMLNode[] children, JSPInfo info) {
            String popup = (String)attrs.get("renderAsPopup");
            if (popup == null) {
                popup = "false";
            }
            StringBuffer sb = new StringBuffer();
            if (popup.equals("true")) {
                sb.append("<input type=\"text\"").append(this.getAttribute(attrs)).append("/>");
                sb.append("<input type=\"button\" value=\"...\"/>");
            } else {
                Calendar cal = Calendar.getInstance();
                cal.set(5, 1);
                int year = cal.get(1);
                int month = cal.get(2);
                sb.append("<table").append(this.getAttribute(attrs)).append(">");
                sb.append("<tr>");
                sb.append("<td><a href=\"#\">&lt;</a></td>");
                sb.append("<td colspan=\"5\">" + Util.getMonthString(cal.getTime()) + " " + year + "</td>");
                sb.append("<td><a href=\"#\">&gt;</a></td>");
                sb.append("</tr>");
                sb.append("<tr>");
                while (cal.get(7) != 1) {
                    cal.add(5, 1);
                }
                int i = 0;
                while (i < 7) {
                    sb.append("<td>").append(Util.getWeekString(cal.getTime())).append("</td>");
                    cal.add(5, 1);
                    ++i;
                }
                sb.append("</tr>");
                int count = 0;
                cal.set(1, year);
                cal.set(2, month);
                cal.set(5, 1);
                while (month == cal.get(2)) {
                    if (count == 0) {
                        sb.append("<tr>");
                    }
                    if (cal.get(5) == 1) {
                        int week = cal.get(7);
                        int i2 = 1;
                        while (i2 != week) {
                            sb.append("<TD></TD>");
                            ++count;
                            ++i2;
                        }
                    }
                    sb.append("<td><a href=\"#\">" + cal.get(5) + "</a></td>");
                    if (++count == 7) {
                        sb.append("</tr>");
                        count = 0;
                    }
                    cal.add(5, 1);
                }
                sb.append("</table>");
            }
            return sb.toString();
        }
    }

    private class SelectConverter
    extends AbstractCustomTagConverter {
        private int mode;

        public SelectConverter(int mode) {
            this.mode = mode;
        }

        public String process(Map attrs, FuzzyXMLNode[] children, JSPInfo info) {
            String itemName = (String)attrs.get("value");
            StringBuffer items = new StringBuffer();
            int itemCount = 0;
            int i = 0;
            while (i < children.length) {
                String[] dim;
                String name;
                if (children[i] instanceof FuzzyXMLElement && (name = ((FuzzyXMLElement)children[i]).getName()).indexOf(":") != -1 && (dim = name.split(":"))[1].equals("selectItem")) {
                    String itemLabel = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)children[i]), (String)"/@itemLabel");
                    String itemValue = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)children[i]), (String)"/@itemValue");
                    if (this.mode == SELECT_MODE_RADIO) {
                        items.append("<input type=\"radio\"");
                        items.append(" name=\"").append(itemName).append("\" value=\"").append(itemValue).append("\">");
                        items.append(itemLabel);
                        items.append("</input>\n");
                    } else if (this.mode == SELECT_MODE_COMBO || this.mode == SELECT_MODE_LIST || this.mode == SELECT_MODE_COMBO_MANY || this.mode == SELECT_MODE_LIST_MANY) {
                        items.append("<option value=\"").append(itemValue).append("\">");
                        items.append(itemLabel);
                        items.append("</option>\n");
                    } else if (this.mode == SELECT_MODE_CHECK) {
                        items.append("<input type=\"checkbox\"");
                        items.append(" name=\"").append(itemName).append("\" value=\"").append(itemValue).append("\">");
                        items.append(itemLabel);
                        items.append("</input>\n");
                    }
                    ++itemCount;
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            if (this.mode == SELECT_MODE_RADIO || this.mode == SELECT_MODE_CHECK) {
                String layout = (String)attrs.get("layout");
                boolean horizontal = true;
                if (layout != null && layout.equals("pageDirection")) {
                    horizontal = false;
                }
                if (items.length() == 0) {
                    if (this.mode == SELECT_MODE_RADIO) {
                        items.append("<input type=\"radio\">One</input>\n");
                        items.append("<input type=\"radio\">Two</input>\n");
                        items.append("<input type=\"radio\">Three</input>\n");
                    } else if (this.mode == SELECT_MODE_CHECK) {
                        items.append("<input type=\"checkbox\">One</input>\n");
                        items.append("<input type=\"checkbox\">Two</input>\n");
                        items.append("<input type=\"checkbox\">Three</input>\n");
                    }
                }
                String[] dim = items.toString().split("\n");
                sb.append("<table").append(this.getAttribute(attrs)).append(">");
                if (horizontal) {
                    sb.append("<tr>");
                }
                int i2 = 0;
                while (i2 < dim.length) {
                    if (horizontal) {
                        sb.append("<td>").append(dim[i2]).append("</td>\n");
                    } else {
                        sb.append("<tr><td>").append(dim[i2]).append("</td></tr>\n");
                    }
                    ++i2;
                }
                if (horizontal) {
                    sb.append("</tr>");
                }
                sb.append("</table>\n");
                return sb.toString();
            }
            if (this.mode == SELECT_MODE_COMBO || this.mode == SELECT_MODE_COMBO_MANY) {
                if (this.mode == SELECT_MODE_COMBO_MANY) {
                    attrs.put("multiple", "true");
                    attrs.put("size", "1");
                }
                sb.append("<select name=\"").append(itemName).append("\"").append(this.getAttribute(attrs)).append(">");
            } else if (this.mode == SELECT_MODE_LIST || this.mode == SELECT_MODE_LIST_MANY) {
                String size = (String)attrs.get("size");
                if (size == null || size.equals("")) {
                    size = String.valueOf(itemCount);
                }
                if (this.mode == SELECT_MODE_LIST_MANY) {
                    attrs.put("multiple", "true");
                }
                sb.append("<select name=\"").append(itemName).append("\" size=\"").append(size).append("\"").append(this.getAttribute(attrs)).append(">");
            }
            sb.append(items.toString());
            if (this.mode == SELECT_MODE_COMBO || this.mode == SELECT_MODE_LIST || this.mode == SELECT_MODE_COMBO_MANY || this.mode == SELECT_MODE_LIST_MANY) {
                sb.append("</select>");
            }
            return sb.toString();
        }
    }

    private class CheckboxConverter
    extends AbstractCustomTagConverter {
        private CheckboxConverter() {
        }

        public String process(Map attrs, FuzzyXMLNode[] children, JSPInfo info) {
            StringBuffer sb = new StringBuffer();
            sb.append("<input type=\"checkbox\"").append(this.getAttribute(attrs)).append(">");
            if (attrs.get("title") != null) {
                sb.append(attrs.get("title"));
            }
            sb.append("</input>");
            return sb.toString();
        }
    }

    private class PanelGridConverter
    extends AbstractCustomTagConverter {
        private PanelGridConverter() {
        }

        public String process(Map attrs, FuzzyXMLNode[] children, JSPInfo info) {
            String headerClass = (String)attrs.get("headerClass");
            String footerClass = (String)attrs.get("footerClass");
            int columns = 1;
            try {
                columns = Integer.parseInt((String)attrs.get("columns"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] columnClasses = null;
            if (attrs.get("columnClasses") != null) {
                columnClasses = ((String)attrs.get("columnClasses")).split(",");
                HTMLUtil.trim((String[])columnClasses);
            }
            String[] rowClasses = null;
            if (attrs.get("rowClasses") != null) {
                rowClasses = ((String)attrs.get("rowClasses")).split(",");
                HTMLUtil.trim((String[])rowClasses);
            }
            FuzzyXMLElement header = null;
            FuzzyXMLElement footer = null;
            ArrayList<FuzzyXMLElement> cells = new ArrayList<FuzzyXMLElement>();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof FuzzyXMLElement) {
                    FuzzyXMLElement element = (FuzzyXMLElement)children[i];
                    if (element.getName().equals("f:facet")) {
                        if ("header".equals(element.getAttributeValue("name"))) {
                            header = element;
                        } else if ("footer".equals(element.getAttributeValue("name"))) {
                            footer = element;
                        }
                    } else {
                        cells.add(element);
                    }
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<table ").append(this.getAttribute(attrs)).append(">\n");
            if (header != null) {
                sb.append("<thead>\n");
                sb.append("<tr>\n");
                sb.append("<th colspan=\"").append(columns).append("\"");
                if (headerClass != null) {
                    sb.append(" class=\"").append(headerClass).append("\"");
                }
                sb.append(">\n");
                sb.append(this.evalBody((FuzzyXMLNode)HTMLUtil.getFirstElement((FuzzyXMLElement)header), info));
                sb.append("</th>\n");
                sb.append("</tr>\n");
                sb.append("</thead>\n");
            }
            if (footer != null) {
                sb.append("<tfoot>\n");
                sb.append("<tr>\n");
                sb.append("<td colspan=\"").append(columns).append("\"");
                if (footerClass != null) {
                    sb.append(" class=\"").append(footerClass).append("\"");
                }
                sb.append(">\n");
                sb.append(this.evalBody((FuzzyXMLNode)HTMLUtil.getFirstElement((FuzzyXMLElement)footer), info));
                sb.append("</td>\n");
                sb.append("</tr>\n");
                sb.append("</tfoot>\n");
            }
            int row = 0;
            int i2 = 0;
            while (i2 < cells.size()) {
                if (i2 % columns == 0) {
                    if (i2 != 0) {
                        sb.append("</tr>\n");
                    }
                    sb.append("<tr");
                    if (rowClasses != null) {
                        sb.append(" class=\"").append(rowClasses[row % rowClasses.length]).append("\"");
                    }
                    sb.append(">\n");
                    ++row;
                }
                FuzzyXMLElement element = (FuzzyXMLElement)cells.get(i2);
                sb.append("<td");
                if (columnClasses != null) {
                    sb.append(" class=\"").append(columnClasses[i2 % columnClasses.length]).append("\"");
                }
                sb.append(">\n");
                sb.append(this.evalBody((FuzzyXMLNode)element, info));
                sb.append("</td>\n");
                ++i2;
            }
            sb.append("</tr>\n");
            sb.append("</table>\n");
            return sb.toString();
        }
    }
}

