/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.ResourceBundle;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.SaveAsImageAction;
import tk.eclipse.plugin.jsf.editors.editparts.NavigationEditPartFactory;
import tk.eclipse.plugin.jsf.editors.editparts.PageEditPart;
import tk.eclipse.plugin.jsf.editors.models.ForwardModel;
import tk.eclipse.plugin.jsf.editors.models.PageModel;
import tk.eclipse.plugin.jsf.editors.models.RootModel;

public class NavigationEditor
extends GraphicalEditorWithPalette {
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
    private boolean savePreviouslyNeeded = false;
    public static final String OPEN_SELECTION = "__faces_config_open_selection";
    private FacesConfigOperation operation;
    static /* synthetic */ Class class$0;

    public NavigationEditor(FacesConfigOperation operation) {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getActionRegistry().registerAction((IAction)new UndoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new RedoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new OpenAction());
        this.operation = operation;
    }

    public GraphicalViewer getViewer() {
        return this.getGraphicalViewer();
    }

    public IAction getAction(Object key) {
        return this.getActionRegistry().getAction(key);
    }

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        PaletteGroup tools = new PaletteGroup(this.resource.getString("editor.palette.group.tool"));
        SelectionToolEntry tool = new SelectionToolEntry();
        tools.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tools.add((PaletteEntry)tool);
        PaletteDrawer flows = new PaletteDrawer(this.resource.getString("editor.palette.group.flow"));
        CreationToolEntry pageEntry = new CreationToolEntry(this.resource.getString("editor.palette.page"), this.resource.getString("editor.palette.page.tooltip"), (CreationFactory)new PageModelFactory(), JSFPlugin.getDefault().getImageDescriptor("__icon_page"), JSFPlugin.getDefault().getImageDescriptor("__icon_page"));
        flows.add((PaletteEntry)pageEntry);
        ConnectionCreationToolEntry forwardEntry = new ConnectionCreationToolEntry(this.resource.getString("editor.palette.forward"), this.resource.getString("editor.palette.forward.tooltip"), (CreationFactory)new ForwardModelFactory(), JSFPlugin.getDefault().getImageDescriptor("__icon_forward"), JSFPlugin.getDefault().getImageDescriptor("__icon_forward"));
        flows.add((PaletteEntry)forwardEntry);
        root.add((PaletteEntry)tools);
        root.add((PaletteEntry)flows);
        return root;
    }

    public IProject getProject() {
        return ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
    }

    private File getBinaryFile(IFile file) {
        return new File(file.getParent().getLocation().makeAbsolute().toFile(), "." + file.getName() + ".faceside");
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        ScalableFreeformRootEditPart rootEditPart = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(manager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(manager));
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        File binary = this.getBinaryFile(file);
        RootModel root = null;
        if (binary.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(binary));
                root = (RootModel)ois.readObject();
                ois.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                root = new RootModel();
            }
        } else {
            root = new RootModel();
        }
        viewer.setContents((Object)root);
        final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this);
        deleteAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)deleteAction);
        this.getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteAction.update();
                ((OpenAction)NavigationEditor.this.getAction(NavigationEditor.OPEN_SELECTION)).update((IStructuredSelection)NavigationEditor.this.getGraphicalViewer().getSelection());
            }
        });
        PrintAction printAction = new PrintAction((IWorkbenchPart)this);
        printAction.setImageDescriptor(JSFPlugin.getDefault().getImageDescriptor("__icon_print_edit"));
        printAction.setText(JSFPlugin.getResourceString("action.print"));
        this.getActionRegistry().registerAction((IAction)printAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add(this.getAction(OPEN_SELECTION));
        menuMgr.add((IContributionItem)new Separator("edit"));
        menuMgr.add(this.getAction(ActionFactory.UNDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.REDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.DELETE.getId()));
        menuMgr.add((IContributionItem)new Separator("zoom"));
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        menuMgr.add((IContributionItem)new Separator("print"));
        menuMgr.add((IAction)new SaveAsImageAction(viewer));
        menuMgr.add((IAction)printAction);
        viewer.setContextMenu(menuMgr);
        this.setPartName(((IFileEditorInput)this.getEditorInput()).getFile().getName());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new NavigationEditPartFactory(this, this.operation));
    }

    public void update(String source) {
        int fromCount = 1;
        int toCount = 1;
        RootModel root = (RootModel)this.getGraphicalViewer().getContents().getModel();
        ArrayList<PageModel> pages = new ArrayList<PageModel>();
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(source);
        FuzzyXMLNode[] rules = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/faces-config/navigation-rule");
        int i = 0;
        while (i < rules.length) {
            String fromview = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)rules[i]), (String)"/from-view-id");
            if (fromview != null && !fromview.equals("")) {
                PageModel page = this.getPageModel(fromview, pages);
                if (page == null) {
                    page = new PageModel();
                    page.setPath(fromview);
                    page.setConstraint(new Rectangle(50, fromCount * 50, -1, -1));
                    ++fromCount;
                }
                if (!pages.contains(page)) {
                    pages.add(page);
                }
                FuzzyXMLNode[] cases = XPath.selectNodes((FuzzyXMLElement)((FuzzyXMLElement)rules[i]), (String)"/navigation-case");
                int j = 0;
                while (j < cases.length) {
                    String action = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)cases[j]), (String)"/from-action");
                    String outcome = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)cases[j]), (String)"/from-outcome");
                    String toview = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)cases[j]), (String)"/to-view-id");
                    if (toview != null && !toview.equals("")) {
                        ForwardModel conn;
                        PageModel target = this.getPageModel(toview, pages);
                        if (target == null) {
                            target = new PageModel();
                            target.setPath(toview);
                            target.setConstraint(new Rectangle(200, toCount * 50, -1, -1));
                            ++toCount;
                        }
                        if (!pages.contains(target)) {
                            pages.add(target);
                        }
                        if ((conn = this.getForwardModel(page, target)) == null) {
                            conn = new ForwardModel();
                            conn.setSource(page);
                            conn.setTarget(target);
                            conn.attachSource();
                            conn.attachTarget();
                        }
                        if (action != null) {
                            conn.setFromAction(action);
                        }
                        if (outcome != null) {
                            conn.setFromOutcome(outcome);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        root.removeAll();
        i = 0;
        while (i < pages.size()) {
            root.addChild(pages.get(i));
            ++i;
        }
    }

    private PageModel getPageModel(String path, List pages) {
        PageModel page;
        RootModel root = (RootModel)this.getGraphicalViewer().getContents().getModel();
        List list = root.getChildren();
        int i = 0;
        while (i < list.size()) {
            page = (PageModel)list.get(i);
            if (page.getPath().equals(path)) {
                return page;
            }
            ++i;
        }
        i = 0;
        while (i < pages.size()) {
            page = (PageModel)pages.get(i);
            if (page.getPath().equals(path)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    private ForwardModel getForwardModel(PageModel from, PageModel to) {
        List list = from.getModelSourceConnections();
        int i = 0;
        while (i < list.size()) {
            ForwardModel forward = (ForwardModel)list.get(i);
            PageModel target = (PageModel)forward.getTarget();
            if (target != null && target.getPath().equals(to.getPath())) {
                return forward;
            }
            ++i;
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void doSave() {
        this.doSave(this.getEditorInput());
    }

    public void doSave(IEditorInput input) {
        this.setInput(input);
        try {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            File binary = this.getBinaryFile(file);
            FileOutputStream out = new FileOutputStream(binary);
            this.writeModel(out);
            out.close();
        }
        catch (Exception ex) {
            Util.openErrorDialog(ex);
        }
        this.getCommandStack().markSaveLocation();
    }

    private void writeModel(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.getGraphicalViewer().getContents().getModel());
        out.close();
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void updateIconStatus() {
        this.getGraphicalViewer().getContents().refresh();
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected void flushCommandStack() {
        super.getCommandStack().flush();
    }

    private class OpenAction
    extends Action {
        private Object target;

        public OpenAction() {
            super(NavigationEditor.this.resource.getString("outline.menu.open"));
            this.setId(NavigationEditor.OPEN_SELECTION);
        }

        public void update(IStructuredSelection sel) {
            Object obj = sel.getFirstElement();
            if (obj != null) {
                if (obj instanceof PageEditPart) {
                    this.setEnabled(true);
                    this.target = ((PageEditPart)obj).getModel();
                } else if (obj instanceof PageEditPart) {
                    this.setEnabled(true);
                    this.target = ((PageEditPart)obj).getModel();
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this.target instanceof PageModel) {
                Util.openPage(NavigationEditor.this.getProject(), (PageModel)this.target);
            }
        }
    }

    private class PageModelFactory
    implements CreationFactory {
        static /* synthetic */ Class class$0;

        private PageModelFactory() {
        }

        public Object getNewObject() {
            try {
                boolean cont;
                int count = 1;
                RootModel root = (RootModel)NavigationEditor.this.getGraphicalViewer().getContents().getModel();
                List children = root.getChildren();
                block2: do {
                    cont = false;
                    int i = 0;
                    while (i < children.size()) {
                        PageModel page;
                        Object obj = children.get(i);
                        if (obj instanceof PageModel && (page = (PageModel)obj).getPath().equals("/page" + count + ".jsp")) {
                            ++count;
                            cont = true;
                            continue block2;
                        }
                        ++i;
                    }
                } while (cont);
                PageModel model = new PageModel();
                model.setPath("/page" + count + ".jsp");
                ++count;
                return model;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.jsf.editors.models.PageModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }

    private class ForwardModelFactory
    implements CreationFactory {
        static /* synthetic */ Class class$0;

        private ForwardModelFactory() {
        }

        public Object getNewObject() {
            try {
                boolean cont;
                int count = 1;
                RootModel root = (RootModel)NavigationEditor.this.getGraphicalViewer().getContents().getModel();
                List children = root.getChildren();
                block2: do {
                    cont = false;
                    int i = 0;
                    while (i < children.size()) {
                        Object obj = children.get(i);
                        if (obj instanceof PageModel) {
                            PageModel action = (PageModel)obj;
                            List conns = action.getModelSourceConnections();
                            int j = 0;
                            while (j < conns.size()) {
                                ForwardModel forward;
                                Object conn = conns.get(j);
                                if (conn instanceof ForwardModel && (forward = (ForwardModel)conn).getFromOutcome().equals("case" + count)) {
                                    ++count;
                                    cont = true;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (cont) continue block2;
                        ++i;
                    }
                } while (cont);
                ForwardModel model = new ForwardModel();
                model.setFromOutcome("case" + count);
                ++count;
                return model;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.jsf.editors.models.ForwardModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }
}

