/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.jsf.editors.models.ForwardModel;
import tk.eclipse.plugin.jsf.editors.models.PageModel;

public class PageEditPart
extends AbstractEntityEditPart {
    private FacesConfigOperation operation;
    private PageDirectEditManager directManager = null;
    static /* synthetic */ Class class$0;

    public PageEditPart(IFile file, FacesConfigOperation operation) {
        super(file);
        this.operation = operation;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new PageDirectEditPolicy());
    }

    protected IFigure createFigure() {
        PageModel model = (PageModel)this.getModel();
        String path = model.getPath();
        if (path.equals("")) {
            path = "<page>";
        }
        Label label = new Label();
        label.setText(path);
        if (this.exists(model.getPath())) {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page"));
        } else {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page_warn"));
        }
        label.setTextPlacement(4);
        return label;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Label label = (Label)this.getFigure();
        PageModel model = (PageModel)this.getModel();
        if (this.exists(model.getPath())) {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page"));
        } else {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page_warn"));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PageModel model;
        super.propertyChange(evt);
        Label label = (Label)this.getFigure();
        String propName = evt.getPropertyName();
        if (propName.equals("__prop_path")) {
            String path = (String)evt.getNewValue();
            if (path.equals("")) {
                path = "<page>";
            }
            label.setText(path);
            this.operation.updateNavigationPath((String)evt.getOldValue(), (String)evt.getNewValue());
        }
        if (this.exists((model = (PageModel)this.getModel()).getPath())) {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page"));
        } else {
            label.setIcon(JSFPlugin.getDefault().getImage("__image_page_warn"));
        }
        try {
            if (propName.equals("_target_connection")) {
                if (evt.getNewValue() == null) {
                    ForwardModel forward = (ForwardModel)evt.getOldValue();
                    PageModel source = (PageModel)forward.getSource();
                    String fromViewId = source.getPath();
                    String toViewId = model.getPath();
                    this.operation.removeNavigation(fromViewId, toViewId);
                } else {
                    ForwardModel forward = (ForwardModel)evt.getNewValue();
                    PageModel source = (PageModel)forward.getSource();
                    String fromViewId = source.getPath();
                    String toViewId = model.getPath();
                    String fromOutCome = forward.getFromOutcome();
                    String fromAction = forward.getFromAction();
                    this.operation.addNavigation(fromViewId, toViewId, fromOutCome, fromAction);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean exists(String path) {
        block7: {
            block6: {
                if (path != null && !path.equals("")) break block6;
                return false;
            }
            if (path.indexOf("*") < 0) break block7;
            return true;
        }
        try {
            IProject project = this.getFile().getProject();
            HTMLProjectParams params = new HTMLProjectParams(project);
            if (project.getFile(new Path(params.getRoot()).append(path)).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        if (req.getType().equals("open")) {
            Util.openPage(this.getFile().getProject(), (PageModel)this.getModel());
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.directManager = new PageDirectEditManager(clazz, new PageCellEditorLocator(this.getFigure()));
        }
        this.directManager.show();
    }

    private class PageDirectEditManager
    extends DirectEditManager {
        public PageDirectEditManager(Class editorType, CellEditorLocator locator) {
            super((GraphicalEditPart)PageEditPart.this, editorType, locator);
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((PageModel)PageEditPart.this.getModel()).getPath());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class PageCellEditorLocator
    implements CellEditorLocator {
        private IFigure figure;

        public PageCellEditorLocator(IFigure f) {
            this.figure = f;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.figure.getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y + 32, rect.width, rect.height - 32);
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldPath;
        private String newPath;

        private DirectEditCommand() {
        }

        public void execute() {
            PageModel model = (PageModel)PageEditPart.this.getModel();
            this.oldPath = model.getPath();
            model.setPath(this.newPath);
        }

        public void setPath(String text) {
            this.newPath = text;
        }

        public void undo() {
            PageModel model = (PageModel)PageEditPart.this.getModel();
            model.setPath(this.oldPath);
        }
    }

    private class PageDirectEditPolicy
    extends DirectEditPolicy {
        private PageDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setPath((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

