/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.document;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.myfaces.custom.document.AbstractDocument;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;

public abstract class AbstractDocumentRenderer
extends Renderer {
    protected abstract String getHtmlTag();

    protected abstract Class getDocumentClass();

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, this.getDocumentClass());
        AbstractDocument document = (AbstractDocument)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (document.isEndState()) {
            this.writeBeforeEnd(facesContext);
        }
        if (document.hasState() && document.isEndState()) {
            writer.endElement(this.getHtmlTag());
        } else {
            writer.startElement(this.getHtmlTag(), uiComponent);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractDocument document = (AbstractDocument)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (!document.hasState()) {
            this.writeBeforeEnd(facesContext);
            writer.endElement(this.getHtmlTag());
        }
    }

    protected void writeBeforeEnd(FacesContext facesContext) throws IOException {
    }
}

