/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.component.html.ext.HtmlDataTable;
import org.apache.myfaces.custom.column.HtmlColumn;
import org.apache.myfaces.custom.crosstable.UIColumns;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlTableRendererBase;

public class HtmlTableRenderer
extends HtmlTableRendererBase {
    public static final String DETAIL_STAMP_FACET_NAME = "detailStamp";

    protected void afterRow(FacesContext facesContext, UIData uiData) throws IOException {
        super.afterRow(facesContext, uiData);
        this.renderDetailRow(facesContext, uiData);
    }

    private void renderDetailRow(FacesContext facesContext, UIData uiData) throws IOException {
        HtmlDataTable htmlDataTable;
        UIComponent detailStampFacet = uiData.getFacet(DETAIL_STAMP_FACET_NAME);
        if (uiData instanceof HtmlDataTable && (htmlDataTable = (HtmlDataTable)uiData).isCurrentDetailExpanded()) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("tr", (UIComponent)uiData);
            writer.startElement("td", (UIComponent)uiData);
            writer.writeAttribute("colspan", (Object)new Integer(uiData.getChildren().size()), null);
            if (detailStampFacet != null) {
                RendererUtils.renderChild(facesContext, detailStampFacet);
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent instanceof HtmlDataTable) {
            HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
            if (htmlDataTable.isRenderedIfEmpty() || htmlDataTable.getRowCount() > 0) {
                super.encodeBegin(facesContext, uiComponent);
            }
        } else {
            super.encodeBegin(facesContext, uiComponent);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlDataTable) {
            HtmlDataTable htmlDataTable = (HtmlDataTable)component;
            if (htmlDataTable.isRenderedIfEmpty() || htmlDataTable.getRowCount() > 0) {
                super.encodeChildren(facesContext, component);
            }
        } else {
            super.encodeChildren(facesContext, component);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (uiComponent instanceof HtmlDataTable) {
            HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
            if (htmlDataTable.isRenderedIfEmpty() || htmlDataTable.getRowCount() > 0) {
                super.encodeEnd(facesContext, uiComponent);
            }
        } else {
            super.encodeEnd(facesContext, uiComponent);
        }
    }

    protected void renderRowStart(FacesContext facesContext, ResponseWriter writer, UIData uiData, Iterator rowStyleClassIterator) throws IOException {
        super.renderRowStart(facesContext, writer, uiData, rowStyleClassIterator);
        HtmlDataTable table = (HtmlDataTable)uiData;
        this.renderRowAttribute(writer, "onclick", table.getRowOnClick());
        this.renderRowAttribute(writer, "ondblclick", table.getRowOnDblClick());
        this.renderRowAttribute(writer, "onkeydown", table.getRowOnKeyDown());
        this.renderRowAttribute(writer, "onkeypress", table.getRowOnKeyPress());
        this.renderRowAttribute(writer, "onkeyup", table.getRowOnKeyUp());
        this.renderRowAttribute(writer, "onmousedown", table.getRowOnMouseDown());
        this.renderRowAttribute(writer, "onmousemove", table.getRowOnMouseMove());
        this.renderRowAttribute(writer, "onmouseout", table.getRowOnMouseOut());
        this.renderRowAttribute(writer, "onmouseover", table.getRowOnMouseOver());
        this.renderRowAttribute(writer, "onmouseup", table.getRowOnMouseUp());
    }

    protected void renderRowStyle(FacesContext facesContext, ResponseWriter writer, UIData uiData, Iterator rowStyleIterator) throws IOException {
        String rowStyle;
        String rowStyleClass;
        if (uiData instanceof HtmlDataTable) {
            HtmlDataTable datatable = (HtmlDataTable)uiData;
            rowStyleClass = datatable.getRowStyleClass();
            rowStyle = datatable.getRowStyle();
        } else {
            rowStyleClass = (String)uiData.getAttributes().get("org.apache.myfaces.dataTable.ROW_STYLECLASS");
            rowStyle = (String)uiData.getAttributes().get("org.apache.myfaces.dataTable.ROW_STYLE");
        }
        if (rowStyleClass == null) {
            super.renderRowStyle(facesContext, writer, uiData, rowStyleIterator);
        } else {
            if (rowStyleIterator.hasNext()) {
                rowStyleIterator.next();
            }
            writer.writeAttribute("class", (Object)rowStyleClass, null);
        }
        if (rowStyle != null) {
            writer.writeAttribute("style", (Object)rowStyle, null);
        }
    }

    protected void renderRowAttribute(ResponseWriter writer, String htmlAttribute, Object value) throws IOException {
        if (value != null) {
            writer.writeAttribute(htmlAttribute, value, null);
        }
    }

    protected void encodeColumnChild(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Iterator columnStyleIterator) throws IOException {
        super.encodeColumnChild(facesContext, writer, uiData, component, columnStyleIterator);
        if (component instanceof UIColumns) {
            UIColumns columns = (UIColumns)component;
            int colSize = columns.getRowCount();
            for (int k = 0; k < colSize; ++k) {
                columns.setRowIndex(k);
                this.renderColumnBody(facesContext, writer, uiData, component, columnStyleIterator);
            }
            columns.setRowIndex(-1);
        }
    }

    protected void renderColumnBody(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Iterator columnStyleIterator) throws IOException {
        if (component instanceof HtmlColumn) {
            writer.startElement("td", (UIComponent)uiData);
            String styleClass = ((HtmlColumn)component).getStyleClass();
            if (columnStyleIterator.hasNext()) {
                if (styleClass == null) {
                    styleClass = (String)columnStyleIterator.next();
                } else {
                    columnStyleIterator.next();
                }
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            this.renderHtmlColumnAttributes(writer, component, null);
            RendererUtils.renderChild(facesContext, component);
            writer.endElement("td");
        } else {
            super.renderColumnBody(facesContext, writer, uiData, component, columnStyleIterator);
        }
    }

    protected void renderColumnChildHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String styleClass, boolean header) throws IOException {
        super.renderColumnChildHeaderOrFooterRow(facesContext, writer, uiComponent, styleClass, header);
        if (uiComponent instanceof UIColumns) {
            UIColumns columns = (UIColumns)uiComponent;
            int size = columns.getRowCount();
            for (int i = 0; i < size; ++i) {
                columns.setRowIndex(i);
                if (header) {
                    this.renderColumnHeaderCell(facesContext, writer, (UIComponent)columns, columns.getHeader(), styleClass, 0);
                    continue;
                }
                this.renderColumnFooterCell(facesContext, writer, (UIComponent)columns, columns.getFooter(), styleClass, 0);
            }
            columns.setRowIndex(-1);
        }
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String headerStyleClass, int colspan) throws IOException {
        if (uiComponent instanceof HtmlColumn) {
            String styleClass;
            writer.startElement("th", uiComponent);
            if (colspan > 1) {
                writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
            }
            if ((styleClass = ((HtmlColumn)uiComponent).getHeaderstyleClass()) == null) {
                styleClass = headerStyleClass;
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            this.renderHtmlColumnAttributes(writer, uiComponent, "header");
            if (facet != null) {
                RendererUtils.renderChild(facesContext, facet);
            }
            writer.endElement("th");
        } else {
            super.renderColumnHeaderCell(facesContext, writer, uiComponent, facet, headerStyleClass, colspan);
        }
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String footerStyleClass, int colspan) throws IOException {
        if (uiComponent instanceof HtmlColumn) {
            String styleClass;
            writer.startElement("td", uiComponent);
            if (colspan > 1) {
                writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
            }
            if ((styleClass = ((HtmlColumn)uiComponent).getFooterstyleClass()) == null) {
                styleClass = footerStyleClass;
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            this.renderHtmlColumnAttributes(writer, uiComponent, "footer");
            if (facet != null) {
                RendererUtils.renderChild(facesContext, facet);
            }
            writer.endElement("td");
        } else {
            super.renderColumnFooterCell(facesContext, writer, uiComponent, facet, footerStyleClass, colspan);
        }
    }

    protected void renderHtmlColumnAttributes(ResponseWriter writer, UIComponent uiComponent, String prefix) throws IOException {
        String[] attrs = HTML.COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE;
        int size = attrs.length;
        for (int i = 0; i < size; ++i) {
            String attributeName = attrs[i];
            String compAttrName = prefix != null ? prefix + attributeName : attributeName;
            HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, compAttrName, attributeName);
        }
        String compAttrName = prefix != null ? prefix + "style" : "style";
        HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, compAttrName, "style");
        HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, "width", "width");
    }

    protected int determineChildColSpan(UIComponent uiComponent) {
        int result = super.determineChildColSpan(uiComponent);
        if (uiComponent instanceof UIColumns) {
            result += ((UIColumns)uiComponent).getRowCount();
        }
        return result;
    }

    protected boolean hasFacet(boolean header, UIComponent uiComponent) {
        boolean result = super.hasFacet(header, uiComponent);
        if (!result && uiComponent instanceof UIColumns) {
            UIColumns columns = (UIColumns)uiComponent;
            result = header ? columns.getHeader() != null : columns.getFooter() != null;
        }
        return result;
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String footerStyleClass) throws IOException {
        if (this.determineRenderFacet(component, false)) {
            super.renderColumnFooterRow(facesContext, writer, component, footerStyleClass);
        }
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String headerStyleClass) throws IOException {
        if (this.determineRenderFacet(component, true)) {
            super.renderColumnHeaderRow(facesContext, writer, component, headerStyleClass);
        }
    }

    protected boolean determineRenderFacet(UIComponent component, boolean header) {
        Iterator it = this.getChildren(component).iterator();
        while (it.hasNext()) {
            UIComponent facet;
            UIComponent uiComponent = (UIComponent)it.next();
            if (!uiComponent.isRendered() || this.determineChildColSpan(uiComponent) <= 0 || (facet = header ? (UIComponent)uiComponent.getFacets().get("header") : (UIComponent)uiComponent.getFacets().get("footer")) == null || !facet.isRendered()) continue;
            return true;
        }
        return false;
    }
}

