/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.util.MyFacesObjectInputStream;

public final class StateUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_tomahawk$util$StateUtils == null ? (class$org$apache$myfaces$shared_tomahawk$util$StateUtils = StateUtils.class$("org.apache.myfaces.shared_tomahawk.util.StateUtils")) : class$org$apache$myfaces$shared_tomahawk$util$StateUtils));
    public static final String ZIP_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_ALGORITHM = "DES";
    public static final String DEFAULT_ALGORITHM_PARAMS = "ECB/PKCS5Padding";
    public static final String INIT_PREFIX = "org.apache.myfaces.";
    public static final String INIT_SECRET = "org.apache.myfaces.secret";
    public static final String INIT_ALGORITHM = "org.apache.myfaces.algorithm";
    public static final String INIT_SECRET_KEY_CACHE = "org.apache.myfaces.secret.cache";
    public static final String INIT_ALGORITHM_IV = "org.apache.myfaces.algorithm.iv";
    public static final String INIT_ALGORITHM_PARAM = "org.apache.myfaces.algorithm.parameters";
    static /* synthetic */ Class class$org$apache$myfaces$shared_tomahawk$util$StateUtils;

    private StateUtils() {
    }

    private static void testConfiguration(String algorithmParams, String iv) {
        if (algorithmParams != null && algorithmParams.startsWith("CBC") && iv == null) {
            throw new FacesException("org.apache.myfaces.algorithm.parameters parameter has been set with CBC mode, but no initialization vector has been set  with org.apache.myfaces.algorithm.iv");
        }
    }

    public static boolean isSecure(ExternalContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        return ctx.getInitParameter(INIT_SECRET) != null;
    }

    public static final String construct(Object object, ExternalContext ctx) {
        byte[] bytes = StateUtils.getAsByteArray(object);
        if (StateUtils.isSecure(ctx)) {
            bytes = StateUtils.encrypt(bytes, ctx);
        }
        bytes = StateUtils.compress(bytes);
        bytes = StateUtils.encode(bytes);
        try {
            return new String(bytes, ZIP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] getAsByteArray(Object object) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream writer = new ObjectOutputStream(outputStream);
            writer.writeObject(object);
            byte[] bytes = outputStream.toByteArray();
            writer.close();
            outputStream.close();
            writer = null;
            outputStream = null;
            return bytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static byte[] encrypt(byte[] insecure, ExternalContext ctx) {
        return StateUtils.symmetric(insecure, ctx, 1);
    }

    public static final byte[] compress(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            gzip.write(bytes, 0, bytes.length);
            gzip.finish();
            byte[] fewerBytes = baos.toByteArray();
            gzip.close();
            baos.close();
            gzip = null;
            baos = null;
            return fewerBytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] encode(byte[] bytes) {
        return new Base64().encode(bytes);
    }

    public static final Object reconstruct(String string, ExternalContext ctx) {
        try {
            byte[] bytes = string.getBytes(ZIP_CHARSET);
            bytes = StateUtils.decode(bytes);
            bytes = StateUtils.decompress(bytes);
            if (StateUtils.isSecure(ctx)) {
                bytes = StateUtils.decrypt(bytes, ctx);
            }
            return StateUtils.getAsObject(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] decode(byte[] bytes) {
        return new Base64().decode(bytes);
    }

    public static final byte[] decompress(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        try {
            int length;
            GZIPInputStream gis = new GZIPInputStream(bais);
            while ((length = gis.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] moreBytes = baos.toByteArray();
            baos.close();
            bais.close();
            gis.close();
            baos = null;
            bais = null;
            gis = null;
            return moreBytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] secure, ExternalContext ctx) {
        return StateUtils.symmetric(secure, ctx, 2);
    }

    public static final Object getAsObject(byte[] bytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        try {
            MyFacesObjectInputStream s = new MyFacesObjectInputStream(input);
            Object object = s.readObject();
            s.close();
            input.close();
            s = null;
            input = null;
            return object;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static String encode64(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(baos);
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(obj);
            oos.close();
            ((OutputStream)zos).close();
            baos.close();
            Base64 base64Codec = new Base64();
            return new String(base64Codec.encode(baos.toByteArray()), ZIP_CHARSET);
        }
        catch (IOException e) {
            log.fatal((Object)"Cannot encode Object with Base64", (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] bytes = StateUtils.encode(args[0].getBytes(ZIP_CHARSET));
        System.out.println(new String(bytes, ZIP_CHARSET));
    }

    private static byte[] symmetric(byte[] data, SecretKey secretKey, String algorithm, String algorithmParams, byte[] iv, int mode) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm + "/" + algorithmParams);
            if (iv != null) {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(mode, (Key)secretKey, ivSpec);
            } else {
                cipher.init(mode, secretKey);
            }
            if (log.isDebugEnabled()) {
                String action = mode == 1 ? "encrypting" : "decrypting";
                log.debug((Object)(action + " w/ " + algorithm + "/" + algorithmParams));
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private static byte[] symmetric(byte[] data, byte[] secret, String algorithm, String algorithmParams, byte[] iv, int mode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"creating new SecretKey");
        }
        SecretKeySpec secretKey = new SecretKeySpec(secret, algorithm);
        return StateUtils.symmetric(data, secretKey, algorithm, algorithmParams, iv, mode);
    }

    private static byte[] symmetric(byte[] data, ExternalContext ctx, int mode) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        String _secret = ctx.getInitParameter(INIT_SECRET);
        String _algorithm = ctx.getInitParameter(INIT_ALGORITHM);
        String _algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM);
        String _iv = ctx.getInitParameter(INIT_ALGORITHM_IV);
        String _cache = ctx.getInitParameter(INIT_SECRET_KEY_CACHE);
        if (_secret == null) {
            throw new NullPointerException("secret for org.apache.myfaces.secret not located in deployment descriptor");
        }
        if (_algorithm == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using default algorithm DES");
            }
            _algorithm = DEFAULT_ALGORITHM;
        }
        if (_algorithmParams == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using default algorithm paramaters ECB/PKCS5Padding");
            }
            _algorithmParams = DEFAULT_ALGORITHM_PARAMS;
        }
        StateUtils.testConfiguration(_algorithmParams, _iv);
        Base64 base64 = new Base64();
        byte[] iv = null;
        if (_iv != null) {
            iv = base64.decode(_iv.getBytes());
        }
        if (_cache != null && "false".equals(_cache)) {
            byte[] secret = base64.decode(_secret.getBytes());
            return StateUtils.symmetric(data, secret, _algorithm, _algorithmParams, iv, mode);
        }
        Object object = ctx.getApplicationMap().get(INIT_SECRET_KEY_CACHE);
        if (object == null) {
            throw new NullPointerException("The context parameter 'org.apache.myfaces.secret.cache' is not set to false, yet there is nothing stored in the application map w/ the following key 'org.apache.myfaces.secret.cache'. It was either not placed there by StartupServletContextListener or something has removed it.");
        }
        if (!(object instanceof SecretKey)) {
            throw new ClassCastException("Did not find an instance of SecretKey in application scope using the key 'org.apache.myfaces.secret.cache'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"using cached SecretKey");
        }
        return StateUtils.symmetric(data, (SecretKey)object, _algorithm, _algorithmParams, iv, mode);
    }

    public static void initSecret(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ServletContext ctx");
        }
        String cache = ctx.getInitParameter(INIT_SECRET_KEY_CACHE);
        if ("false".equals(cache)) {
            return;
        }
        String _secret = ctx.getInitParameter(INIT_SECRET);
        String _algorithm = ctx.getInitParameter(INIT_ALGORITHM);
        if (_algorithm == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using default algorithm DES");
            }
            _algorithm = DEFAULT_ALGORITHM;
        }
        if (_secret == null) {
            throw new NullPointerException("_secret String - 'org.apache.myfaces.secret.cache' has been enabled, but there is no 'org.apache.myfaces.secret'");
        }
        byte[] secret = new Base64().decode(_secret.getBytes());
        SecretKeySpec secretKey = new SecretKeySpec(secret, _algorithm);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Storing SecretKey @ org.apache.myfaces.secret.cache");
        }
        ctx.setAttribute(INIT_SECRET_KEY_CACHE, (Object)secretKey);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

