package tk.eclipse.plugin.visualjsf;

import java.util.Set;

import org.eclipse.gef.requests.SimpleFactory;

import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.DataColumnModel;
import tk.eclipse.plugin.visualjsf.models.DataTableModel;

public class VisualJSFModelFactory extends SimpleFactory {
	
	private Set names;
	
	public VisualJSFModelFactory(Class aClass, Set componentNames) {
		super(aClass);
		this.names = componentNames;
	}

	public Object getNewObject() {
		Object obj = super.getNewObject();
		if(obj!=null && obj instanceof AbstractJSFModel){
			int count = 1;
			while(true){
				AbstractJSFModel model = (AbstractJSFModel)obj;
				String name = model.getComponentName() + count;
				if(!names.contains(name)){
					model.setName(name);
					break;
				}
				count++;
			}
		}
		
		if(obj instanceof DataTableModel){
			DataTableModel tableModel = (DataTableModel)obj;
			for(int i=0;i<3;i++){
				DataColumnModel column = new DataColumnModel();
				column.setColumnName("Column" + (i + 1));
				tableModel.addChild(column);
			}
		}
		
		return obj;
	}
}
