package tk.eclipse.plugin.visualjsf.descriptors;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionDialog;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.gefutils.AbstractDialogPropertyDescriptor;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;

public abstract class AbstractBindingDescriptor extends AbstractDialogPropertyDescriptor {
	
	public AbstractBindingDescriptor(Object id, String displayName) {
		super(id, displayName);
	}

	protected Object openDialogBox(Object obj, Control cellEditorWindow){
		try {
			String value = (String)obj;
			
			IEditorPart editorPart = HTMLUtil.getActiveEditor();
			
			IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
			IJavaProject project = JavaCore.create(input.getFile().getProject());
			JSFProject jsfProject = new JSFProject(project);
			ManagedBean[] beans = jsfProject.getManagedBeans();

			ManagedBeanMethod initial = null;
			if(value.startsWith("#{") && value.endsWith("}")){
				value = value.replaceAll("^#\\{", "");
				value = value.replaceAll("\\}$", "");
				String[] dim = Util.splitManagedBean(value);
				if(dim.length==2){
					for(int i=0;i<beans.length;i++){
						if(beans[i].getBeanName().equals(dim[0])){
							initial = new ManagedBeanMethod(beans[i], dim[1]);
						}
					}
				}
			}
			
			Shell shell = cellEditorWindow.getShell();
			AbstractBindingSelectionDialog dialog = createSelectionDialog(shell, beans, initial);
			
			if(dialog.open()==SelectionDialog.OK){
				Object[] result = dialog.getResult();
				if(result!=null && result.length==1 && result[0] instanceof ManagedBeanMethod){
					return convertToString((ManagedBeanMethod)result[0]);
				} else {
					return null;
				}
			}
		} catch(Exception ex){
			VisualJSFPlugin.logException(ex);
		}
		return null;
	}
	
	protected abstract AbstractBindingSelectionDialog createSelectionDialog(
			Shell shell, ManagedBean[] beans, ManagedBeanMethod initial);
	
	private String convertToString(ManagedBeanMethod method){
		StringBuffer sb = new StringBuffer();
		sb.append("#{");
		sb.append(method.getParent().getBeanName());
		sb.append(".");
		sb.append(method.getMethodName());
		sb.append("}");
		return sb.toString();
	}
}
