package tk.eclipse.plugin.visualjsf.editparts;

import java.beans.PropertyChangeEvent;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.ContainerModel;
import tk.eclipse.plugin.visualjsf.models.IActionModel;
import tk.eclipse.plugin.visualjsf.models.IValueChangeListenerModel;

/**
 * @author Naoki Takezoe
 */
public abstract class AbstractJSFEditPart extends AbstractEditPart {
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE,new EntityComponentEditPolicy());
	}

	protected void refreshVisuals() {
		Object model = getModel();
		if(model instanceof AbstractJSFModel){
			Rectangle constraint = ((AbstractJSFModel)model).getConstraint();
			((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), constraint);
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}
	
	private class EntityComponentEditPolicy extends ComponentEditPolicy {
		protected Command createDeleteCommand(GroupRequest deleteRequest) {
			DeleteCommand command = new DeleteCommand();
			command.setParentModel(getHost().getParent().getModel());
			command.setTargetModel(getHost().getModel());
			return command;
		}
	}
	
	/** Delete command */
	private class DeleteCommand extends Command {
		
		private ContainerModel parent;
		private AbstractJSFModel model;
		
		public void execute() {
			parent.removeChild(model);
		}
		public void setParentModel(Object parent) {
			this.parent = (ContainerModel) parent;
		}
		public void setTargetModel(Object model) {
			this.model = (AbstractJSFModel) model;
		}
		public void undo(){
			parent.addChild(model);
		}
	}
	
	protected IAction createValueChangeListenerAction(String id, String name){
		IValueChangeListenerModel model = (IValueChangeListenerModel)getModel();
		String valueChangeListener = model.getValueChangeListener();
		if(valueChangeListener.startsWith("#{") && valueChangeListener.endsWith("}")){
			valueChangeListener = valueChangeListener.substring(
					valueChangeListener.lastIndexOf('.')+1, valueChangeListener.length()-1);
		} else {
			valueChangeListener = name + "ValueChanged";
		}
		return new CreateValueChangeListenerAction(id, 
						valueChangeListener, model, getViewer());
	}
	
	protected IAction createActionAction(String id, String name){
		IActionModel model = (IActionModel)getModel();
		String action = model.getAction();
		if(action.startsWith("#{") && action.endsWith("}")){
			action = action.substring(action.lastIndexOf('.')+1, action.length()-1);
		} else {
			action = name + "Cliked";
		}
		return new CreateActionAction(id, action, 
						(IActionModel)getModel(), getViewer());
	}

	protected IAction createActionListenerAction(String id, String name){
		IActionModel model = (IActionModel)getModel();
		String action = model.getActionListener();
		if(action.startsWith("#{") && action.endsWith("}")){
			action = action.substring(action.lastIndexOf('.')+1, action.length()-1);
		} else {
			action = name + "ActionPerformed";
		}
		return new CreateActionListenerAction(id, action, 
						(IActionModel)getModel(), getViewer());
	}

}
