package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.Button;
import tk.eclipse.plugin.visualjsf.models.CommandButtonModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.CommandButtonModel}.
 * 
 * @author Naoki Takezoe
 */
public class CommandButtonEditPart extends AbstractJSFEditPart {
	
	protected IFigure createFigure() {
		CommandButtonModel model = (CommandButtonModel)getModel();
		
		Button button = new Button(model.getValue());
		return button;
	}

	protected void refreshVisuals() {
		super.refreshVisuals();
		
		CommandButtonModel model = (CommandButtonModel)getModel();
		Button button = (Button)getFigure();
		button.setText(model.getValue());
	}

	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		CommandButtonModel model = (CommandButtonModel)getModel();
		return new IAction[]{
				createActionAction("commandButton_action", model.getName()),
				createActionListenerAction("commandButton_actionListener", model.getName())
		};
	}

}
