package tk.eclipse.plugin.visualjsf.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.ButtonBorder.ButtonScheme;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Color;

import tk.eclipse.plugin.visualjsf.VisualJSFPlugin;
import tk.eclipse.plugin.visualjsf.models.DataColumnModel;
import tk.eclipse.plugin.visualjsf.models.DataTableModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.DataTableModel}.
 * 
 * @author Naoki Takezoe
 */
public class DataTableEditPart extends AbstractJSFEditPart implements ColorConstants {

	protected IFigure createFigure() {
		Figure figure = new Figure();
		ToolbarLayout layout = new ToolbarLayout(true);
		layout.setSpacing(2);
		figure.setLayoutManager(layout);
		figure.setBorder(new SchemeBorder(new ButtonScheme(
				new Color[] { buttonDarker, buttonLightest },
				new Color[] { buttonLightest, buttonDarkest }
			)));
		return figure;
	}
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new DataTableEditPolicy());
		super.createEditPolicies();
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(DataTableModel.P_COLUMNS)) {
			refreshChildren();
		}
		refreshVisuals();
	}
	
	protected List getModelChildren() {
		DataTableModel model = (DataTableModel)getModel();
		return model.getChildren();
	}

	public IAction[] getMenuActions() {
		return new IAction[]{
				new Action(VisualJSFPlugin.getResourceString("action.addColumn")){
					public void run(){
						DataTableModel model = (DataTableModel)getModel();
						DataColumnModel column = new DataColumnModel();
						column.setColumnName("Column" + (model.getChildren().size() + 1));
						model.addChild(column);
					}
				}
		};
	}
	
	private class DataTableEditPolicy extends LayoutEditPolicy {
		
		protected EditPolicy createChildEditPolicy(EditPart child) {
			return new NonResizableEditPolicy();
		}
		
		protected Command getCreateCommand(CreateRequest request) {
			return null;
		}
		
		protected Command getDeleteDependantCommand(Request request) {
			return null;
		}

		protected Command getMoveChildrenCommand(Request request) {
			return null;
		}
	}
	
}
