package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

import tk.eclipse.plugin.visualjsf.models.CommandButtonModel;
import tk.eclipse.plugin.visualjsf.models.CommandLinkModel;
import tk.eclipse.plugin.visualjsf.models.DataColumnModel;
import tk.eclipse.plugin.visualjsf.models.DataTableModel;
import tk.eclipse.plugin.visualjsf.models.InputSecretModel;
import tk.eclipse.plugin.visualjsf.models.InputTextModel;
import tk.eclipse.plugin.visualjsf.models.InputTextareaModel;
import tk.eclipse.plugin.visualjsf.models.OutputTextModel;
import tk.eclipse.plugin.visualjsf.models.RootModel;
import tk.eclipse.plugin.visualjsf.models.SelectBooleanCheckboxModel;
import tk.eclipse.plugin.visualjsf.models.SelectManyCheckboxModel;
import tk.eclipse.plugin.visualjsf.models.SelectManyListboxModel;
import tk.eclipse.plugin.visualjsf.models.SelectOneMenuModel;
import tk.eclipse.plugin.visualjsf.models.SelectOneRadioModel;

/**
 * 
 * @author Naoki Takezoe
 */
public class JSFEditPartFactory implements EditPartFactory {
	
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart part = null;
		if(model instanceof RootModel){
			part = new RootEditPart();
		} else if(model instanceof CommandButtonModel){
			part = new CommandButtonEditPart();
		} else if(model instanceof CommandLinkModel){
			part = new CommandLinkEditPart();
		} else if(model instanceof OutputTextModel){
			part = new OutputTextEditPart();
		} else if(model instanceof InputSecretModel){
			part = new InputSecretEditPart();
		} else if(model instanceof InputTextareaModel){
			part = new InputTextareaEditPart();
		} else if(model instanceof InputTextModel){
			part = new InputTextEditPart();
		} else if(model instanceof SelectBooleanCheckboxModel){
			part = new SelectBooleanCheckboxEditPart();
		} else if(model instanceof SelectManyCheckboxModel){
			part = new SelectManyCheckboxEditPart();
		} else if(model instanceof SelectManyListboxModel){
			part = new SelectManyListboxEditPart();
		} else if(model instanceof SelectOneRadioModel){
			part = new SelectOneRadioEditPart();
		} else if(model instanceof SelectOneMenuModel){
			part = new SelectOneMenuEditPart();
		} else if(model instanceof DataTableModel){
			part = new DataTableEditPart();
		} else if(model instanceof DataColumnModel){
			part = new DataColumnEditPart();
		} else {
		    return null;
		}
		part.setModel(model);
		return part;
	}
	
}
