package tk.eclipse.plugin.visualjsf.editparts;

import java.util.List;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.RadioButton;
import tk.eclipse.plugin.visualjsf.models.SelectOneRadioModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.SelectOneRadioModel}.
 * 
 * @author Naoki Takezoe
 */
public class SelectOneRadioEditPart extends AbstractJSFEditPart {
	
	protected IFigure createFigure() {
		SelectOneRadioModel model = (SelectOneRadioModel)getModel();
		Figure figure = new Figure();
		updateFigure(figure, model);
		return figure;
	}
	
	protected Figure createItemFigure(String label){
		return new RadioButton(label); 
	}
	
	protected void refreshVisuals() {
		super.refreshVisuals();
		
		SelectOneRadioModel model = (SelectOneRadioModel)getModel();
		Figure figure = (Figure)getFigure();
		updateFigure(figure, model);
		
		figure.getLayoutManager().layout(figure);
		figure.repaint();
	}
	
	private void updateFigure(Figure figure, SelectOneRadioModel model){
		figure.setLayoutManager(new FlowLayout(isHorizontal(model)));
		figure.removeAll();
		if(model.getSelectItems().length() > 0 || model.getSelectItem().isEmpty()){
			figure.add(createItemFigure("One"));
			figure.add(createItemFigure("Two"));
			figure.add(createItemFigure("Three"));
		} else {
			List items = model.getSelectItem();
			for(int i=0;i<items.size();i++){
				String[] item = (String[])items.get(i);
				figure.add(createItemFigure(item[0]));
			}
		}
	}
	
	private boolean isHorizontal(SelectOneRadioModel model){
		String layout = model.getLayout();
		if(layout==null || layout.length()==0 || layout.equals("") ||
				layout.equals("lineDirection")){
			return true;
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		SelectOneRadioModel model = (SelectOneRadioModel)getModel();
		return new IAction[]{
				createValueChangeListenerAction("selectOneRadio_valueChangeListener", 
						model.getName())
		};
	}
	
}
