package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.CommandButtonModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:commandButton.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.CommandButtonModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class CommandButtonLoader extends AbstractFormElementLoader {

	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		CommandButtonModel model = new CommandButtonModel();
		
		model.setValue(getString(element, "value"));
		model.setAction(getString(element, "action"));
		model.setActionListener(getString(element, "actionListener"));
		
		return model;
	}

}
