package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.DataColumnModel;
import tk.eclipse.plugin.visualjsf.models.DataTableModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:dataTable.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.DataTableModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class DataTableLoader extends AbstractFormElementLoader {

	protected AbstractJSFModel loadModel(FuzzyXMLElement element) {
		DataTableModel tableModel = new DataTableModel();
		
		tableModel.setValue(getString(element, "value"));
		tableModel.setVar(getString(element, "var"));
		tableModel.setBorder(getString(element, "border"));
		
		FuzzyXMLElement[] children = getChildElements(element);
		for(int i=0;i<children.length;i++){
			if(children[i].getName().equals("h:column")){
				DataColumnModel columnModel = loadColumn(children[i]);
				tableModel.addChild(columnModel);
			}
		}
		
		return tableModel;
	}
	
	private DataColumnModel loadColumn(FuzzyXMLElement element){
		DataColumnModel columnModel = new DataColumnModel();
		
		FuzzyXMLElement[] children = getChildElements(element);
		for(int i=0;i<children.length;i++){
			if(children[i].getName().equals("f:facet") && getString(children[i], "name").equals("header")){
				FuzzyXMLElement[] facetChildren = getChildElements(children[i]);
				for(int j=0;j<facetChildren.length;j++){
					if(facetChildren[j].getName().equals("h:outputText")){
						columnModel.setColumnName(getString(facetChildren[j] , "value"));
					}
				}
			} else if(children[i].getName().equals("h:outputText")){
				columnModel.setColumnValue(getString(children[i], "value"));
			}
		}
		
		return columnModel;
	}

}
