package tk.eclipse.plugin.visualjsf.loader;

import java.util.HashMap;
import java.util.Map;

import jp.aonir.fuzzyxml.FuzzyXMLElement;

/**
 * 
 * @author Naoki Takezoe
 */
public class ElementLoaderFactory {
	
	private static Map loaders = new HashMap();
	static {
		loaders.put("h:outputText", new OutputTextLoader());
		loaders.put("h:inputText", new InputTextLoader());
		loaders.put("h:inputTextarea", new InputTextareaLoader());
		loaders.put("h:inputSecret", new InputSecretLoader());
		loaders.put("h:commandButton", new CommandButtonLoader());
		loaders.put("h:commandLink", new CommandLinkLoader());
		loaders.put("h:selectBooleanCheckbox", new SelectBooleanCheckboxLoader());
		loaders.put("h:selectManyCheckbox", new SelectManyCheckboxLoader());
		loaders.put("h:selectManyListbox", new SelectManyListboxLoader());
		loaders.put("h:selectOneRadio", new SelectOneRadioLoader());
		loaders.put("h:selectOneMenu", new SelectOneMenuLoader());
		loaders.put("h:dataTable", new DataTableLoader());
	}
	
	/**
	 * Returns the {@link IElementLoader} instance or null.
	 * 
	 * @param element the FuzzyXMLElement of the jsp taglib
	 * @return the {@link IElementLoader} instance or null
	 */
	public static IElementLoader getElementLoader(FuzzyXMLElement element){
		return (IElementLoader)loaders.get(element.getName());
	}
	
	
}
