package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.InputTextareaModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:inputTextarea.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.InputTextareaModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class InputTextareaLoader extends AbstractFormElementLoader {
	
	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		InputTextareaModel model = new InputTextareaModel();
		
		model.setValue(getString(element, "value"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		
		return model;
	}

}
