package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.SelectManyListboxModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:selectManyListbox.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.SelectManyListboxModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class SelectManyListboxLoader extends AbstractSelectElementLoader {
	
	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		SelectManyListboxModel model = new SelectManyListboxModel();
		
		model.setValue(getString(element, "value"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		setItems(model, element);
		
		return model;
	}

}
