package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.SelectOneMenuModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:selectOneMenu.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.SelectOneMenuModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class SelectOneMenuLoader extends AbstractSelectElementLoader {

	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		SelectOneMenuModel model = new SelectOneMenuModel();
		
		model.setValue(getString(element, "value"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		setItems(model, element);
		
		return model;
	}
	
}
