package tk.eclipse.plugin.visualjsf.models;

import java.util.List;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.descriptors.PropertyList;
import tk.eclipse.plugin.visualjsf.descriptors.SelectItemPropertyDescriptor;
import tk.eclipse.plugin.visualjsf.descriptors.ValuePropertyDescriptor;

/**
 * The base class for models which have f:selectItem / f:selectItems
 * as their children.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractJSFSelectModel extends AbstractJSFFormModel {
	
	public static final String P_SELECT_ITEMS = "_select_items";
	public static final String P_SELECT_ITEM = "_select_item";

	private String selectItems = "";
	private List selectItem = new PropertyList();
	
	public AbstractJSFSelectModel(){
		addModelProperty(P_SELECT_ITEMS, new ModelProperty(this, "selectItems", String.class, 
				new ValuePropertyDescriptor(P_SELECT_ITEMS, "selectItems")));
		addModelProperty(P_SELECT_ITEM, new ModelProperty(this, "selectItem", List.class, 
				new SelectItemPropertyDescriptor(P_SELECT_ITEM, "selectItem")));
	}
	
	public String getSelectItems() {
		return selectItems;
	}

	public void setSelectItems(String selectItems) {
		this.selectItems = selectItems;
		firePropertyChange(P_SELECT_ITEMS, null, selectItems);
	}
	
	public List getSelectItem() {
		return selectItem;
	}

	public void setSelectItem(List selectItem) {
		this.selectItem = selectItem;
		firePropertyChange(P_SELECT_ITEM, null, selectItem);
	}
	
	protected String getItemHTML(){
		StringBuffer sb = new StringBuffer();
		if(getSelectItems().length()>0){
			sb.append("<f:selectItems");
			sb.append(" value=\"").append(HTMLUtil.escapeHTML(getSelectItems())).append("\"/>");
		} else {
			for(int i=0;i<this.selectItem.size();i++){
				String[] item = (String[])this.selectItem.get(i);
				sb.append("<f:selectItem");
				sb.append(" itemLabel=\"").append(HTMLUtil.escapeHTML(item[0])).append("\"");
				sb.append(" itemValue=\"").append(HTMLUtil.escapeHTML(item[1])).append("\"/>");
			}
		}
		return sb.toString();
	}
}
