package tk.eclipse.plugin.visualjsf.models;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import tk.eclipse.plugin.htmleditor.HTMLUtil;

/**
 * The model class for h:outputText.
 * 
 * @author Naoki Takezoe
 */
public class OutputTextModel extends AbstractJSFModel {
	
	public static final String P_VALUE = "_value";
	public static final String P_COLOR = "_color";
	public static final String P_SIZE = "_size";
	
	private String value = "";
	private RGB color = null;
	private String size = "10px";
	
	public OutputTextModel(){
		addModelProperty(P_VALUE, new ModelProperty(this, "value", String.class, 
				new TextPropertyDescriptor(P_VALUE, "value")));
		addModelProperty(P_COLOR, new ModelProperty(this, "color", RGB.class, 
				new ColorPropertyDescriptor(P_COLOR, "color")));
		addModelProperty(P_SIZE, new ModelProperty(this, "size", String.class, 
				new TextPropertyDescriptor(P_SIZE, "size")));
	}
	
	public String getComponentClass(){
		return "javax.faces.component.html.HtmlOutputText";
	}
	
	public String getComponentName(){
		return "label";
	}
	
	public String getTagName(){
		return "h:outputText";
	}
	
	public void setValue(String value){
		this.value = value;
		firePropertyChange(P_VALUE, null, value);
	}
	
	public String getValue(){
		return this.value;
	}
	
	public RGB getColor() {
		return color;
	}
	
	public void setColor(RGB color) {
		this.color = color;
		firePropertyChange(P_COLOR, null, color);
	}
	
	public String getSize() {
		return size;
	}

	public void setSize(String size) {
		this.size = size;
		firePropertyChange(P_SIZE, null, size);
	}

	public String toHTML() {
		StringBuffer style = getPositionStyle();
		if(color!=null){
			style.append("color:").append(HTMLUtil.toHex(color)).append(";");
		}
		if(size!=null && size.length()>0){
			style.append("font-size:").append(size).append(";");
		}
		style.append("padding-left:4px;padding-top:4px;");
		
		StringBuffer sb = new StringBuffer();
		sb.append("<").append(getTagName());
		if(getName().length()>0){
			sb.append(" id=\"").append(getName()).append("\"");
		}
		sb.append(" style=\"").append(style.toString()).append("\"");
		if(getValue().length()>0){
			sb.append(" value=\"").append(HTMLUtil.escapeHTML(getValue())).append("\"");
		}
		sb.append(getBindingAttribute());
		sb.append("/>");
		return sb.toString();
	}
	
}
