/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.wizards.ActionFormWizard;
import tk.eclipse.plugin.struts.wizards.ActionWizard;
import tk.eclipse.plugin.struts.wizards.ConfigurationActionWizard;
import tk.eclipse.plugin.struts.wizards.JSPWizard;

public class Util {
    public static int getIndex(String[] array, String value) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static List filtering(List list, Class clazz) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (clazz.isInstance(obj)) {
                result.add(obj);
            }
            ++i;
        }
        return result;
    }

    public static void openJSPWizard(Object container, String fileName) {
        JSPWizard wizard = new JSPWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setFileName(Util.getNoQueryPath(fileName));
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openActionWizard(Object container, String className) {
        ActionWizard wizard = new ActionWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setClassName(className);
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openActionFormWizard(Object container, String className) {
        ActionFormWizard wizard = new ActionFormWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setClassName(className);
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openConfigurationActionWizard(IJavaProject project, ActionModel model, CommandStack stack) {
        ConfigurationActionWizard wizard = new ConfigurationActionWizard(model, stack);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)project));
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openErrorDialog(Throwable ex) {
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, ex.toString(), ex);
        ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
        Shell shell = Display.getCurrent().getActiveShell();
        ErrorDialog.openError((Shell)shell, (String)resource.getString("errorDialog.caption"), (String)resource.getString("errorDialog.message"), (IStatus)status);
        Util.logException(ex);
    }

    public static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public static void logDebug(String message) {
        ILog log = StrutsPlugin.getDefault().getLog();
        Status status = new Status(1, "tk.eclipse.plugin.struts.StrutsPlugin", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logError(String message) {
        ILog log = StrutsPlugin.getDefault().getLog();
        Status status = new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logException(Throwable ex) {
        ILog log = StrutsPlugin.getDefault().getLog();
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, ex.toString(), ex);
        log.log(status);
        ex.printStackTrace();
    }

    public static void openAlertDialog(String message) {
        ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
        MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 1);
        box.setMessage(message);
        box.setText(resource.getString("errorDialog.caption"));
        box.open();
    }

    public static String createMessage(String message, String[] params) {
        int i = 0;
        while (i < params.length) {
            message = message.replaceAll("\\{" + i + "\\}", params[i]);
            ++i;
        }
        return message;
    }

    public static Document createXMLDocument(String xml) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(new StrutsConfigResolver());
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = builder.parse(in);
        in.close();
        return doc;
    }

    public static Document createXMLDocument(InputStream in) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(new StrutsConfigResolver());
        Document doc = builder.parse(in);
        in.close();
        return doc;
    }

    public static String createXMLSource(Document doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DocumentType doctype = doc.getDoctype();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "false");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-system", doctype.getSystemId());
        transformer.setOutputProperty("doctype-public", doctype.getPublicId());
        transformer.transform(new DOMSource(doc), new StreamResult(out));
        out.flush();
        String xml = new String(out.toByteArray());
        out.close();
        return xml;
    }

    public static String getNoQueryPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.indexOf("?") != -1) {
            path = path.substring(0, path.indexOf("?"));
        }
        return path;
    }

    public static String readStream(InputStream in) throws IOException {
        try {
            byte[] buf = new byte[in.available()];
            in.read(buf);
            String string = new String(buf);
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String[] getValidatorRules(StrutsProject project, String moduleName) {
        IFile[] files = project.getValidatorXML(moduleName);
        ArrayList<String> ruleNames = new ArrayList<String>();
        int i = 0;
        while (i < files.length) {
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
                FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"form-validation/global/validator");
                int j = 0;
                while (j < nodes.length) {
                    String name = ((FuzzyXMLElement)nodes[j]).getAttributeValue("name");
                    if (name != null) {
                        ruleNames.add(name);
                    }
                    ++j;
                }
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
            ++i;
        }
        return ruleNames.toArray(new String[ruleNames.size()]);
    }

    public static void openAction(IProject project, ActionModel model) {
        try {
            String type = model.getType();
            if (type == null || type.equals("")) {
                Util.openAlertDialog(StrutsPlugin.getResourceString("error.noClassName"));
                return;
            }
            String path = String.valueOf(type.replaceAll("\\.", "/")) + ".java";
            IFile file = project.getFile(path);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entry = javaProject.getRawClasspath();
            int i = 0;
            while (i < entry.length) {
                if (entry[i].getEntryKind() == 3) {
                    file = project.getFile(entry[i].getPath().removeFirstSegments(1).append(path));
                    break;
                }
                ++i;
            }
            if (file.exists()) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
            } else {
                Util.openActionWizard(project, type);
            }
        }
        catch (Exception ex) {
            Util.openErrorDialog(ex);
        }
    }

    public static void openPage(IProject project, PageModel model) {
        try {
            IFile file;
            HTMLProjectParams params = new HTMLProjectParams(project);
            String webappRoot = params.getRoot();
            ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
            String path = model.getPath();
            if (path == null || path.equals("")) {
                Util.openAlertDialog(resource.getString("error.noJspPath"));
                return;
            }
            String filename = model.getPath();
            String module = model.getModuleName();
            if (filename != null && module != null && !module.equals("")) {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                path = "/" + module + path;
            }
            if ((file = project.getFile(String.valueOf(webappRoot) + Util.getNoQueryPath(path))).exists()) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
            } else {
                IPath containerPath = project.getFullPath();
                containerPath = containerPath.append(webappRoot);
                Object container = null;
                container = containerPath.segmentCount() > 1 ? project.getWorkspace().getRoot().getFolder(containerPath) : project;
                Util.openJSPWizard(container, Util.getNoQueryPath(filename));
            }
        }
        catch (Exception e) {
            Util.openErrorDialog(e);
        }
    }
}

