/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.SaveAsImageAction;
import tk.eclipse.plugin.struts.editors.StrutsConfigOutlinePage;
import tk.eclipse.plugin.struts.editors.editparts.StrutsConfigEditPartFactory;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class GraphicalStrutsConfigEditor
extends GraphicalEditorWithPalette {
    private RootModel root;
    private StrutsConfigOutlinePage outlinePage;
    private boolean savePreviouslyNeeded = false;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    public static final String OPEN_SELECTION = "__struts_config_open_selection";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public GraphicalStrutsConfigEditor(StrutsConfigOutlinePage outlinePage) {
        this.outlinePage = outlinePage;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getActionRegistry().registerAction((IAction)new UndoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new RedoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new OpenAction());
    }

    public IAction getAction(Object key) {
        return this.getActionRegistry().getAction(key);
    }

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        PaletteGroup tools = new PaletteGroup(this.resource.getString("editor.palette.group.tool"));
        SelectionToolEntry tool = new SelectionToolEntry();
        tools.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tools.add((PaletteEntry)tool);
        PaletteDrawer flows = new PaletteDrawer(this.resource.getString("editor.palette.group.flow"));
        CreationToolEntry actionEntry = new CreationToolEntry(this.resource.getString("editor.palette.action"), this.resource.getString("editor.palette.action.tooltip"), (CreationFactory)new ActionModelFactory(), StrutsPlugin.getDefault().getDescriptor("__icon_action"), StrutsPlugin.getDefault().getDescriptor("__icon_action"));
        flows.add((PaletteEntry)actionEntry);
        CreationToolEntry pageEntry = new CreationToolEntry(this.resource.getString("editor.palette.page"), this.resource.getString("editor.palette.page.tooltip"), (CreationFactory)new PageModelFactory(), StrutsPlugin.getDefault().getDescriptor("__icon_webpage"), StrutsPlugin.getDefault().getDescriptor("__icon_webpage"));
        flows.add((PaletteEntry)pageEntry);
        ConnectionCreationToolEntry forwardEntry = new ConnectionCreationToolEntry(this.resource.getString("editor.palette.forward"), this.resource.getString("editor.palette.forward.tooltip"), (CreationFactory)new ForwardModelFactory(), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_forward"), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_forward"));
        flows.add((PaletteEntry)forwardEntry);
        String string = this.resource.getString("editor.palette.exception");
        String string2 = this.resource.getString("editor.palette.exception.tooltip");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.ExceptionModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectionCreationToolEntry exceptionEntry = new ConnectionCreationToolEntry(string, string2, (CreationFactory)new SimpleFactory((Class)clazz), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_exception"), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_exception"));
        flows.add((PaletteEntry)exceptionEntry);
        String string3 = this.resource.getString("editor.palette.input");
        String string4 = this.resource.getString("editor.palette.input.tooltip");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("tk.eclipse.plugin.struts.editors.models.InputModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectionCreationToolEntry inputEntry = new ConnectionCreationToolEntry(string3, string4, (CreationFactory)new SimpleFactory((Class)clazz2), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_input"), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_input"));
        flows.add((PaletteEntry)inputEntry);
        String string5 = this.resource.getString("editor.palette.directforward");
        String string6 = this.resource.getString("editor.palette.directforward.tooltip");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("tk.eclipse.plugin.struts.editors.models.DirectForwardModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectionCreationToolEntry directForwardEntry = new ConnectionCreationToolEntry(string5, string6, (CreationFactory)new SimpleFactory((Class)clazz3), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_directforward"), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_directforward"));
        flows.add((PaletteEntry)directForwardEntry);
        String string7 = this.resource.getString("editor.palette.include");
        String string8 = this.resource.getString("editor.palette.include.tooltip");
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("tk.eclipse.plugin.struts.editors.models.IncludeModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ConnectionCreationToolEntry includeEntry = new ConnectionCreationToolEntry(string7, string8, (CreationFactory)new SimpleFactory((Class)clazz4), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_include"), StrutsPlugin.getDefault().getDescriptor("__icon_arrow_include"));
        flows.add((PaletteEntry)includeEntry);
        root.add((PaletteEntry)tools);
        root.add((PaletteEntry)flows);
        return root;
    }

    public RootModel getRoot() {
        return this.root;
    }

    public void setRoot(RootModel model) {
        if (model != null) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            viewer.setContents((Object)model);
            this.root = model;
            this.root.addPropertyChangeListener(this.outlinePage);
        }
    }

    private File getBinaryFile(IFile file) {
        return new File(file.getParent().getLocation().makeAbsolute().toFile(), "." + file.getName() + ".strutside");
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.outlinePage.setGraphicalViewer(this.getGraphicalViewer());
        ScalableFreeformRootEditPart rootEditPart = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(manager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(manager));
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        File binary = this.getBinaryFile(file);
        if (binary.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(binary));
                this.root = (RootModel)ois.readObject();
                ois.close();
            }
            catch (Exception ex) {
                this.root = new RootModel();
            }
        } else {
            this.root = new RootModel();
            this.root.addPropertyChangeListener(this.outlinePage);
        }
        viewer.setContents((Object)this.root);
        final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this);
        deleteAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)deleteAction);
        this.getGraphicalViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteAction.update();
            }
        });
        PrintAction printAction = new PrintAction((IWorkbenchPart)this);
        printAction.setImageDescriptor(StrutsPlugin.getDefault().getImageRegistry().getDescriptor("__icon_print_edit"));
        printAction.setText(StrutsPlugin.getResourceString("action.print"));
        this.getActionRegistry().registerAction((IAction)printAction);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("open"));
        menuMgr.add((IContributionItem)new GroupMarker("open_end"));
        menuMgr.add((IContributionItem)new Separator("edit"));
        menuMgr.add(this.getAction(ActionFactory.UNDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.REDO.getId()));
        menuMgr.add(this.getAction(ActionFactory.DELETE.getId()));
        menuMgr.add((IContributionItem)new Separator("zoom"));
        menuMgr.add(this.getAction("org.eclipse.gef.zoom_in"));
        menuMgr.add(this.getAction("org.eclipse.gef.zoom_out"));
        menuMgr.add((IContributionItem)new Separator("print"));
        menuMgr.add((IAction)new SaveAsImageAction(viewer));
        menuMgr.add((IAction)printAction);
        viewer.setContextMenu(menuMgr);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection sel = (IStructuredSelection)GraphicalStrutsConfigEditor.this.getGraphicalViewer().getSelection();
                Object selObj = sel.getFirstElement();
                Object selTarget = selObj instanceof EditPart ? ((EditPart)selObj).getModel() : null;
                GraphicalStrutsConfigEditor.this.updateContextMenu(manager, selTarget);
            }
        });
        this.setPartName(((IFileEditorInput)this.getEditorInput()).getFile().getName());
    }

    public void updateContextMenu(IMenuManager manager, Object target) {
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getId() != null && items[i].getId().startsWith(OPEN_SELECTION)) {
                manager.remove(items[i]);
                this.getActionRegistry().removeAction(((ActionContributionItem)items[i]).getAction());
            }
            ++i;
        }
        if (target instanceof ActionModel) {
            ActionModel model = (ActionModel)target;
            OpenAction action = new OpenAction();
            this.getActionRegistry().registerAction((IAction)action);
            manager.appendToGroup("open", (IAction)action);
            action.setEnabled(!model.getType().equals("") && model.getType().indexOf(123) < 0);
            action.update(target);
        } else if (target instanceof PageModel) {
            PageModel model = (PageModel)target;
            if (model.isTile()) {
                String[] paths = model.getPaths();
                int i2 = 0;
                while (i2 < paths.length) {
                    OpenAction action = new OpenAction("__struts_config_open_selection_" + i2, paths[i2]);
                    this.getActionRegistry().registerAction((IAction)action);
                    manager.appendToGroup("open", (IAction)action);
                    action.setEnabled(true);
                    action.update(target);
                    ++i2;
                }
            } else {
                OpenAction action = new OpenAction();
                this.getActionRegistry().registerAction((IAction)action);
                manager.appendToGroup("open", (IAction)action);
                action.setEnabled(!model.getPath().equals("") && model.getPath().indexOf(123) < 0);
                action.update(target);
            }
        }
        manager.update(true);
    }

    public void doSave() {
        this.doSave(this.getEditorInput());
    }

    public void doSave(IEditorInput input) {
        this.setInput(input);
        try {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            File binary = this.getBinaryFile(file);
            FileOutputStream out = new FileOutputStream(binary);
            this.writeModel(out);
            out.close();
        }
        catch (Exception ex) {
            Util.openErrorDialog(ex);
        }
        this.getCommandStack().markSaveLocation();
    }

    private void writeModel(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        out.writeObject(this.root);
        out.close();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void refresh() {
        this.getGraphicalViewer().getContents().refresh();
    }

    public IProject getProject() {
        return ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new StrutsConfigEditPartFactory(this));
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected void flushCommandStack() {
        super.getCommandStack().flush();
    }

    protected List getEditParts() {
        ArrayList editPartList = new ArrayList();
        Map editMap = this.getGraphicalViewer().getVisualPartMap();
        Set key = editMap.keySet();
        Iterator itr = key.iterator();
        while (itr.hasNext()) {
            editPartList.add(editMap.get(itr.next()));
        }
        return editPartList;
    }

    private class OpenAction
    extends Action {
        private Object target;
        private String filename;

        public OpenAction() {
            this(GraphicalStrutsConfigEditor.OPEN_SELECTION, null);
        }

        public OpenAction(String id, String filename) {
            super(String.valueOf(GraphicalStrutsConfigEditor.this.resource.getString("outline.menu.open")) + (filename == null ? "" : " " + filename));
            this.filename = filename;
            this.setId(id);
        }

        public void update(Object selTarget) {
            this.target = selTarget;
        }

        public void run() {
            try {
                HTMLProjectParams params = new HTMLProjectParams(GraphicalStrutsConfigEditor.this.getProject());
                String webappRoot = params.getRoot();
                if (this.target instanceof PageModel) {
                    IFile file;
                    String path;
                    String string = path = this.filename != null ? this.filename : ((PageModel)this.target).getPath();
                    if (path == null || path.equals("")) {
                        Util.openAlertDialog(GraphicalStrutsConfigEditor.this.resource.getString("error.noJspPath"));
                        return;
                    }
                    String module = ((PageModel)this.target).getModuleName();
                    if (this.filename == null && module != null && !module.equals("")) {
                        if (!path.startsWith("/")) {
                            path = "/" + path;
                        }
                        path = "/" + module + path;
                    }
                    if ((file = GraphicalStrutsConfigEditor.this.getProject().getFile(String.valueOf(webappRoot) + Util.getNoQueryPath(path))).exists()) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
                    } else {
                        Util.openJSPWizard(file.getParent(), file.getName());
                    }
                } else if (this.target instanceof ActionModel) {
                    Util.openAction(GraphicalStrutsConfigEditor.this.getProject(), (ActionModel)this.target);
                }
            }
            catch (Exception ex) {
                Util.openErrorDialog(ex);
            }
        }
    }

    private class PageModelFactory
    implements CreationFactory {
        static /* synthetic */ Class class$0;

        private PageModelFactory() {
        }

        public Object getNewObject() {
            try {
                boolean cont;
                int count = 1;
                RootModel root = GraphicalStrutsConfigEditor.this.getRoot();
                List children = root.getChildren();
                block5: do {
                    cont = false;
                    int i = 0;
                    while (i < children.size()) {
                        PageModel page;
                        Object obj = children.get(i);
                        if (obj instanceof PageModel && (page = (PageModel)obj).getPath().equals("/page" + count + ".jsp")) {
                            ++count;
                            cont = true;
                            continue block5;
                        }
                        ++i;
                    }
                } while (cont);
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
                PageModel model = new PageModel();
                model.setPath("/page" + count + ".jsp");
                ++count;
                PageModel pageModel = model;
                return pageModel;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
            finally {
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.PageModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }

    private class ActionModelFactory
    implements CreationFactory {
        static /* synthetic */ Class class$0;

        private ActionModelFactory() {
        }

        public Object getNewObject() {
            try {
                boolean cont;
                int count = 1;
                RootModel root = GraphicalStrutsConfigEditor.this.getRoot();
                List children = root.getChildren();
                block5: do {
                    cont = false;
                    int i = 0;
                    while (i < children.size()) {
                        ActionModel action;
                        Object obj = children.get(i);
                        if (obj instanceof ActionModel && (action = (ActionModel)obj).getPath().equals("/action" + count)) {
                            ++count;
                            cont = true;
                            continue block5;
                        }
                        ++i;
                    }
                } while (cont);
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
                ActionModel model = new ActionModel();
                model.setPath("/action" + count);
                ++count;
                ActionModel actionModel = model;
                return actionModel;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
            finally {
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.ActionModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }

    private class ForwardModelFactory
    implements CreationFactory {
        static /* synthetic */ Class class$0;

        private ForwardModelFactory() {
        }

        public Object getNewObject() {
            try {
                boolean cont;
                int count = 1;
                RootModel root = GraphicalStrutsConfigEditor.this.getRoot();
                List children = root.getChildren();
                block5: do {
                    cont = false;
                    int i = 0;
                    while (i < children.size()) {
                        Object obj = children.get(i);
                        if (obj instanceof ActionModel) {
                            ActionModel action = (ActionModel)obj;
                            List conns = action.getModelSourceConnections();
                            int j = 0;
                            while (j < conns.size()) {
                                ForwardModel forward;
                                Object conn = conns.get(j);
                                if (conn instanceof ForwardModel && (forward = (ForwardModel)conn).getName().equals("forward" + count)) {
                                    ++count;
                                    cont = true;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (cont) continue block5;
                        ++i;
                    }
                } while (cont);
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
                ForwardModel model = new ForwardModel();
                model.setName("forward" + count);
                ++count;
                ForwardModel forwardModel = model;
                return forwardModel;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
            finally {
                StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
            }
        }

        public Object getObjectType() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("tk.eclipse.plugin.struts.editors.models.ForwardModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
    }
}

