/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.io.ByteArrayInputStream;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.StrutsConfigModel2XML;
import tk.eclipse.plugin.struts.StrutsConfigXML2Model;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.TilesDefsXML2Model;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.GraphicalStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.StrutsConfigOutlinePage;
import tk.eclipse.plugin.struts.editors.StrutsConfigXMLEditor;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class MultiPageStrutsConfigEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private GraphicalStrutsConfigEditor graphicalEditor;
    private StrutsConfigXMLEditor textEditor;
    private StrutsConfigOutlinePage outlinePage;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    boolean firstFlag = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public MultiPageStrutsConfigEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.outlinePage = new StrutsConfigOutlinePage(this);
    }

    private void createPage0() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.graphicalEditor = new GraphicalStrutsConfigEditor(this.outlinePage);
                int index = this.addPage((IEditorPart)this.graphicalEditor, this.getEditorInput());
                this.setPageText(index, this.resource.getString("editor.tab.flow"));
            }
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    private void createPage1() {
        try {
            this.textEditor = new StrutsConfigXMLEditor();
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(index, this.resource.getString("editor.tab.source"));
        }
        catch (PartInitException e) {
            Util.openErrorDialog(e);
        }
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
        this.syncEditors(1);
    }

    public RootModel getRoot() {
        return this.graphicalEditor.getRoot();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.syncEditors(this.getActivePage());
        if (this.graphicalEditor != null) {
            IProject project = ((FileEditorInput)this.textEditor.getEditorInput()).getFile().getProject();
            this.getRoot().setTilesRoot(TilesDefsXML2Model.createModel(project, this.getRoot()));
        }
        this.textEditor.doSave(monitor);
        this.setInput(this.textEditor.getEditorInput());
        if (this.graphicalEditor != null) {
            this.graphicalEditor.doSave(this.textEditor.getEditorInput());
        }
        this.setPartName(this.textEditor.getEditorInput().getName());
    }

    public void doSaveAs() {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        if (this.isDirty()) {
            if (newPageIndex == 0) {
                this.graphicalEditor.flushCommandStack();
                this.syncEditors(1);
            } else if (newPageIndex == 1) {
                this.syncEditors(0);
            }
        }
        super.pageChange(newPageIndex);
    }

    public void syncEditors(int activePage) {
        if (this.graphicalEditor == null) {
            return;
        }
        if (activePage == 0) {
            IFile file = ((FileEditorInput)this.graphicalEditor.getEditorInput()).getFile();
            StrutsProject strutsProject = new StrutsProject(file.getProject());
            String xml = StrutsConfigModel2XML.createStrutsConfig(this.graphicalEditor.getRoot(), strutsProject.getExtension());
            this.textEditor.setDiff(xml);
        } else if (activePage == 1) {
            IEditorInput input = this.textEditor.getEditorInput();
            IDocument doc = this.textEditor.getDocumentProvider().getDocument((Object)input);
            String xml = doc.get();
            try {
                IFile file = ((FileEditorInput)this.graphicalEditor.getEditorInput()).getFile();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(file.getCharset()));
                RootModel model = StrutsConfigXML2Model.createModel(in, this.graphicalEditor.getRoot(), file);
                this.graphicalEditor.setRoot(model);
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
        }
        this.outlinePage.update();
    }

    public IDocument getDocument() {
        IEditorInput input = this.textEditor.getEditorInput();
        IDocument doc = this.textEditor.getDocumentProvider().getDocument((Object)input);
        return doc;
    }

    public void setFocus() {
        if (this.graphicalEditor != null) {
            if (this.firstFlag) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    window.getActivePage().showView("org.eclipse.ui.views.PropertySheet");
                    window.getActivePage().showView("org.eclipse.ui.views.ContentOutline");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.firstFlag = false;
            }
            IProject project = ((FileEditorInput)this.textEditor.getEditorInput()).getFile().getProject();
            this.getRoot().setTilesRoot(TilesDefsXML2Model.createModel(project, this.getRoot()));
        }
        super.setFocus();
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.textEditor.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)MultiPageStrutsConfigEditor.this, false);
                    } else if (!MultiPageStrutsConfigEditor.this.getPartName().equals(file.getName())) {
                        MultiPageStrutsConfigEditor.this.setPartName(file.getName());
                    } else if (HTMLUtil.contains((IResourceDelta)event.getDelta(), (IFile)file)) {
                        MultiPageStrutsConfigEditor.this.updateGraphicalEditor();
                    }
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && this.graphicalEditor != null) {
            return this.outlinePage;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            this.setActivePage(1);
            return this.textEditor.getAdapter(adapter);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(adapter)) {
            return this.textEditor;
        }
        if (this.getActiveEditor() == this.textEditor) {
            return this.textEditor.getAdapter(adapter);
        }
        if (this.graphicalEditor != null) {
            return this.graphicalEditor.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    private void updateGraphicalEditor() {
        if (this.graphicalEditor != null) {
            this.syncEditors(1);
            this.graphicalEditor.refresh();
        }
    }

    public XMLEditor getXMLEditor() {
        return this.textEditor;
    }

    public GraphicalStrutsConfigEditor getGraphicalEditor() {
        return this.graphicalEditor;
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }
}

