/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.htmleditor.gefutils.LabelArrowConnection;
import tk.eclipse.plugin.struts.editors.editparts.AbstractStrutsConnectionEditPart;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;

public class ExceptionEditPart
extends AbstractStrutsConnectionEditPart {
    private ExceptionDirectEditManager directManager;
    static /* synthetic */ Class class$0;

    protected IFigure createFigure() {
        ExceptionModel model = (ExceptionModel)this.getModel();
        String name = model.getType();
        if (name.equals("")) {
            name = "<exception>";
        }
        LabelArrowConnection connection = new LabelArrowConnection(Display.getCurrent().getSystemColor(3));
        connection.setText(name);
        this.addDefaultBendpoints();
        return connection;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ExceptionDirectEditPolicy());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        if (propName.equals("_type")) {
            String type = (String)evt.getNewValue();
            if (type.equals("")) {
                type = "<exception>";
            }
            LabelArrowConnection connection = (LabelArrowConnection)this.getFigure();
            connection.setText(type);
            this.refreshVisuals();
        }
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.directManager = new ExceptionDirectEditManager(clazz, new ExceptionCellEditorLocator(this.getFigure()));
        }
        this.directManager.show();
    }

    private class ExceptionDirectEditManager
    extends DirectEditManager {
        public ExceptionDirectEditManager(Class editorType, CellEditorLocator locator) {
            super((GraphicalEditPart)ExceptionEditPart.this, editorType, locator);
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((ExceptionModel)ExceptionEditPart.this.getModel()).getType());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class ExceptionCellEditorLocator
    implements CellEditorLocator {
        private IFigure figure;

        public ExceptionCellEditorLocator(IFigure f) {
            this.figure = f;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = ((LabelArrowConnection)this.figure).getLabel().getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldType;
        private String newType;

        private DirectEditCommand() {
        }

        public void execute() {
            ExceptionModel model = (ExceptionModel)ExceptionEditPart.this.getModel();
            this.oldType = model.getType();
            model.setType(this.newType);
        }

        public void setType(String type) {
            this.newType = type;
        }

        public void undo() {
            ExceptionModel model = (ExceptionModel)ExceptionEditPart.this.getModel();
            model.setType(this.oldType);
        }
    }

    private class ExceptionDirectEditPolicy
    extends DirectEditPolicy {
        private ExceptionDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setType((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

