/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsConfigModel2XML;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.wizards.StrutsWizardPage;
import tk.eclipse.plugin.struts.wizards.StrutsWizardPage2;

public class StrutsWizard
extends Wizard
implements INewWizard {
    private StrutsWizardPage page1;
    private StrutsWizardPage2 page2;
    private IStructuredSelection selection;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    public static final String[] JARS = new String[]{"/struts-1.2/commons-beanutils.jar", "/struts-1.2/commons-collections.jar", "/struts-1.2/commons-digester.jar", "/struts-1.2/commons-fileupload.jar", "/struts-1.2/commons-logging.jar", "/struts-1.2/commons-validator.jar", "/struts-1.2/jakarta-oro.jar", "/struts-1.2/struts.jar"};
    public static final String[] TLDS = new String[]{"/struts-1.2/struts-bean.tld", "/struts-1.2/struts-html.tld", "/struts-1.2/struts-logic.tld", "/struts-1.2/struts-nested.tld", "/struts-1.2/struts-tiles.tld"};
    public static final String MESSAGE = "/struts-1.2/MessageResources.properties";
    public static final String[] VALIDATOR_FILES = new String[]{"/struts-1.2/validation.xml", "/struts-1.2/validator-rules.xml"};
    public static final String TILES = "/struts-1.2/tiles-defs.xml";

    public StrutsWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.resource.getString("wizard.strutsSupport.title"));
    }

    public boolean performFinish() {
        final String projectName = this.page1.getWebAppRoot();
        final boolean addJARs = this.page1.getAddStrutsLibraries();
        final boolean addTLDs = this.page1.getAddTLDFiles();
        final boolean createStrutsConfigXML = this.page1.getCreateStrutsConfigXML();
        final boolean createWebXML = this.page1.getCreateWebXML();
        final boolean createMessage = this.page1.getCreateMessageResources();
        final boolean useValidator = this.page2.getUseValidator();
        final boolean useTiles = this.page2.getUseTiles();
        final String mapping = this.page1.getMapping();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        StrutsWizard.this.doFinish(projectName, addJARs, addTLDs, createStrutsConfigXML, createWebXML, createMessage, useValidator, useTiles, mapping, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Util.openErrorDialog(realException);
            return false;
        }
        return true;
    }

    private void doFinish(String path, boolean addJARs, boolean addTLDs, boolean createStrutsConfigXML, boolean createWebXML, boolean createMessage, boolean useValidator, boolean useTiles, String mapping, IProgressMonitor monitor) throws Exception {
        File libdir;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(path));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            Util.throwCoreException(Util.createMessage(this.resource.getString("error.notexists"), new String[]{path}));
        }
        this.addNature(resource.getProject(), path);
        int totalTask = 0;
        if (addJARs) {
            totalTask += JARS.length;
        }
        if (addTLDs) {
            totalTask += TLDS.length;
        }
        if (createStrutsConfigXML) {
            ++totalTask;
        }
        if (createWebXML) {
            ++totalTask;
        }
        if (createMessage) {
            ++totalTask;
        }
        if (useValidator) {
            totalTask += VALIDATOR_FILES.length;
        }
        if (useTiles) {
            ++totalTask;
        }
        monitor.beginTask(StrutsPlugin.getResourceString("wizard.strutsSupport.title"), totalTask);
        IContainer container = (IContainer)resource;
        File webinf = container.getFolder((IPath)new Path("/WEB-INF")).getLocation().makeAbsolute().toFile();
        if (!webinf.exists()) {
            webinf.mkdir();
        }
        if (!(libdir = container.getFolder((IPath)new Path("/WEB-INF/lib")).getLocation().makeAbsolute().toFile()).exists()) {
            libdir.mkdir();
        }
        if (addJARs) {
            int i = 0;
            while (i < JARS.length) {
                this.copyFile(monitor, container, JARS[i], "/WEB-INF/lib");
                monitor.worked(1);
                ++i;
            }
            container.refreshLocal(2, monitor);
            try {
                IJavaProject project = JavaCore.create((IProject)container.getProject());
                IClasspathEntry[] rawClasspath = project.getRawClasspath();
                ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
                list.addAll(Arrays.asList(rawClasspath));
                int i2 = 0;
                while (i2 < JARS.length) {
                    String fileName = new File(JARS[i2]).getName();
                    IClasspathEntry classPath = JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(path) + "/WEB-INF/lib/" + fileName), null, null);
                    if (!list.contains(classPath)) {
                        list.add(classPath);
                    }
                    ++i2;
                }
                IClasspathEntry[] newClasspath = list.toArray(new IClasspathEntry[list.size()]);
                project.setRawClasspath(newClasspath, monitor);
            }
            catch (Exception project) {
                // empty catch block
            }
        }
        if (addTLDs) {
            int i = 0;
            while (i < TLDS.length) {
                this.copyFile(monitor, container, TLDS[i], "/WEB-INF");
                monitor.worked(1);
                ++i;
            }
        }
        if (createStrutsConfigXML) {
            try {
                IFile file = container.getFile((IPath)new Path("/WEB-INF/struts-config.xml"));
                InputStream stream = this.createStrutsConfigStream(createMessage, useValidator, useTiles);
                if (file.exists()) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.create(stream, true, monitor);
                }
                stream.close();
            }
            catch (IOException file) {
                // empty catch block
            }
            monitor.worked(1);
        }
        if (createWebXML) {
            URL url = StrutsPlugin.getDefault().getBundle().getEntry("/struts-1.2/web.xml");
            try {
                String source = Util.readStream(url.openStream());
                source = source.replaceAll("<url-pattern>\\*\\.do</url-pattern>", "<url-pattern>" + mapping + "</url-pattern>");
                IFile file = container.getFile((IPath)new Path("/WEB-INF/web.xml"));
                ByteArrayInputStream stream = new ByteArrayInputStream(source.getBytes());
                if (file.exists()) {
                    file.setContents((InputStream)stream, true, true, monitor);
                } else {
                    file.create((InputStream)stream, true, monitor);
                }
                ((InputStream)stream).close();
            }
            catch (Exception source) {
                // empty catch block
            }
            monitor.worked(1);
        }
        if (useValidator) {
            int i = 0;
            while (i < VALIDATOR_FILES.length) {
                this.copyFile(monitor, container, VALIDATOR_FILES[i], "/WEB-INF");
                monitor.worked(1);
                ++i;
            }
        }
        if (useTiles) {
            this.copyFile(monitor, container, TILES, "/WEB-INF");
            monitor.worked(1);
        }
        if (createMessage) {
            IJavaProject project = JavaCore.create((IProject)container.getProject());
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IResource classpath = roots[i].getResource();
                if (classpath != null && (classpath instanceof IFolder || classpath instanceof IProject)) {
                    this.copyFile(monitor, (IContainer)project.getProject(), MESSAGE, classpath.getProjectRelativePath().toString());
                    break;
                }
                ++i;
            }
            monitor.worked(1);
        }
        container.refreshLocal(2, monitor);
    }

    private void addNature(IProject project, String path) throws Exception {
        HTMLProjectParams params = new HTMLProjectParams();
        params.setRoot("/" + new Path(path).removeFirstSegments(1).toString());
        params.save(project);
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("tk.eclipse.plugin.struts.StrutsProjectNature")) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "tk.eclipse.plugin.struts.StrutsProjectNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    private synchronized void copyFile(IProgressMonitor monitor, IContainer container, String entry, String target) {
        try {
            URL url = StrutsPlugin.getDefault().getBundle().getEntry(entry);
            String fileName = new File(entry).getName();
            File file = container.getFile((IPath)new Path(String.valueOf(target) + "/" + fileName)).getLocation().makeAbsolute().toFile();
            InputStream in = url.openStream();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, length);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception ex) {
            System.out.println(entry);
            ex.printStackTrace();
            Util.openErrorDialog(ex);
        }
    }

    private InputStream createStrutsConfigStream(boolean createMessage, boolean useValidator, boolean useTiles) {
        StringBuffer sb = new StringBuffer();
        RootModel root = new RootModel();
        root.setCharset("UTF-8");
        root.setDtdName("struts-config");
        root.setDtdPublicId("-//Apache Software Foundation//DTD Struts Configuration 1.2//EN");
        root.setDtdSystemId("http://struts.apache.org/dtds/struts-config_1_2.dtd");
        if (createMessage) {
            MessageResourcesModel message = new MessageResourcesModel();
            message.setParameter("MessageResources");
            root.addChild(message);
        }
        if (useTiles) {
            PluginModel tilesPlugin = new PluginModel();
            tilesPlugin.setClassName("org.apache.struts.tiles.TilesPlugin");
            Properties tilesProps = new Properties();
            tilesProps.addProperty("definitions-config", "/WEB-INF/tiles-defs.xml", null);
            tilesProps.addProperty("moduleAware", "true", null);
            tilesPlugin.setProperties(tilesProps);
            root.addChild(tilesPlugin);
            ControllerModel controller = new ControllerModel();
            controller.setProcessorClass("org.apache.struts.tiles.TilesRequestProcessor");
            root.addChild(controller);
        }
        if (useValidator) {
            PluginModel validatorPlugin = new PluginModel();
            validatorPlugin.setClassName("org.apache.struts.validator.ValidatorPlugIn");
            Properties validatorProps = new Properties();
            validatorProps.addProperty("pathnames", "/WEB-INF/validator-rules.xml,/WEB-INF/validation.xml", null);
            validatorPlugin.setProperties(validatorProps);
            root.addChild(validatorPlugin);
        }
        sb.append(StrutsConfigModel2XML.createStrutsConfig(root, ".do"));
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page1 = new StrutsWizardPage((ISelection)this.selection);
        this.page2 = new StrutsWizardPage2((ISelection)this.selection);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }
}

