package net.java.amateras.db.view.dialect;

import java.sql.Types;
import java.util.List;

import net.java.amateras.db.visual.model.ColumnModel;
import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class HsqldbDialect implements IDialect {
	
	private static final String DB_NAME = DialectProvider.HSQLDB;
	
	private static final IColumnType[] COLUMN_TYPES = {
		new ColumnType("INT", true, Types.INTEGER),
		new ColumnType("INTEGER", true, Types.INTEGER),
		new ColumnType("DOUBLE", true, Types.DOUBLE),
		new ColumnType("FLOAT", true, Types.FLOAT),
		new ColumnType("VARCHAR", true, Types.VARCHAR),
		new ColumnType("VARCHAR_IGNORECASE", true, Types.VARCHAR),
		new ColumnType("CHAR", true, Types.CHAR),
		new ColumnType("CHARACTER", true, Types.CHAR),
		new ColumnType("DECIMAL", true, Types.DECIMAL),
		new ColumnType("NUMERIC", true, Types.NUMERIC),
		new ColumnType("BOOLEAN", true, Types.BOOLEAN),
		new ColumnType("BIT", true, Types.BIT),
		new ColumnType("TINYINT", true, Types.TINYINT),
		new ColumnType("SMALLINT", true, Types.SMALLINT),
		new ColumnType("BIGINT", true, Types.BIGINT),
		new ColumnType("REAL", true, Types.REAL),
		new ColumnType("BINATY", true, Types.BINARY),
		new ColumnType("VARBINATY", true, Types.BINARY),
		new ColumnType("LONGBINARY", true, Types.BINARY),
		new ColumnType("DATE", false, Types.DATE),
		new ColumnType("TIME", false, Types.TIME),
		new ColumnType("TIMESTAMP", false, Types.TIMESTAMP),
		new ColumnType("DATETIME", false, Types.TIMESTAMP),
		new ColumnType("OTHER", false, Types.OTHER),
		new ColumnType("OBJECT", false, Types.OTHER)
	};
	
	public IColumnType getColumnType(int sqlType){
		for(int i=0;i<COLUMN_TYPES.length;i++){
			if(sqlType==COLUMN_TYPES[i].getType()){
				return COLUMN_TYPES[i];
			}
		}
		return COLUMN_TYPES[0];
	}
	
	public IColumnType[] getColumnTypes() {
		return COLUMN_TYPES;
	}

	public String getDBName() {
		return DB_NAME;
	}

	public String createDDL(RootModel model, boolean drop) {
		List children = TableDependencyCalculator.getSortedTable(model);
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<children.size();i++){
			Object obj = children.get(i);
			if(obj instanceof TableModel){
				sb.append(createDDL((TableModel)obj, drop));
				sb.append("\n");
			}
		}
		return sb.toString();
	}

	public String createDDL(TableModel model, boolean drop) {
		StringBuffer sb = new StringBuffer();
		
		if(drop){
			sb.append("DROP TABLE ").append(model.getTableName()).append(";\n\n");
		}
		
		sb.append("CREATE TABLE ").append(model.getTableName()).append("(\n");
		ColumnModel[] columns = model.getColumns();
		for(int i=0;i<columns.length;i++){
			if(i!=0){
				sb.append(",\n");
			}
			sb.append("  ").append(columns[i].getColumnName());
			sb.append(" ").append(columns[i].getColumnType().getName());
			if(columns[i].getColumnType().supportSize()){
				sb.append("(").append(columns[i].getSize()).append(")");
			}
			if(columns[i].isNotNull()){
				sb.append(" NOT NULL");
			}
			if(columns[i].isPrimaryKey()){
				sb.append(" PRIMARY KEY");
			}
		}

		List fkList = model.getModelSourceConnections();
		for(int i=0;i<fkList.size();i++){
			ForeignKeyModel conn = (ForeignKeyModel)fkList.get(i);
			ForeignKeyMapping[] mappings = conn.getMapping();
			TableModel target = (TableModel)conn.getTarget();
			sb.append(",\n");
			sb.append("  ").append("FOREIGN KEY (");
			for(int j=0;j<mappings.length;j++){
				if(j!=0){
					sb.append(",");
				}
				sb.append(mappings[j].getRefer().getColumnName());
			}
			sb.append(") REFERENCES ");
			sb.append(target.getTableName());
			sb.append(" (");
			for(int j=0;j<mappings.length;j++){
				if(j!=0){
					sb.append(",");
				}
				sb.append(mappings[j].getTarget().getColumnName());
			}
			sb.append(")");
		}
		
		sb.append("\n");
		sb.append(");\n");
		
		return sb.toString();
	}
}
