package net.java.amateras.db.view.dialect;

import java.util.ArrayList;
import java.util.List;

import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.db.visual.model.TableModel;

public class TableDependencyCalculator {
	
	public static List getSortedTable(RootModel root){
		List result = new ArrayList();
		List children = root.getChildren();
		for(int i=0;i<children.size();i++){
			Object obj = children.get(i);
			if(obj instanceof TableModel){
				TableModel table = (TableModel)obj;
				int index = -1;
				List conns = table.getModelTargetConnections();
				for(int j=0;j<conns.size();j++){
					ForeignKeyModel conn = (ForeignKeyModel)conns.get(j);
					TableModel target = (TableModel)conn.getTarget();
					if(result.contains(target)){
						int targetIndex = result.indexOf(target);
						if(index < targetIndex){
							index = targetIndex;
						}
					}
				}
				if(index >= 0){
					result.add(index, table);
				} else {
					result.add(table);
				}
			}
		}
		return result;
	}
	
}
