package net.java.amateras.db.visual.editor;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import net.java.amateras.db.visual.model.RootModel;
import net.java.amateras.xstream.XStreamSerializer;

public class VisualDBSerializer {

	public static InputStream serialize(RootModel model) throws UnsupportedEncodingException {
		return XStreamSerializer.serializeStream(model, VisualDBSerializer.class.getClassLoader());
	}
	
	public static RootModel deserialize(InputStream in) throws UnsupportedEncodingException {
		return (RootModel)XStreamSerializer.deserialize(in, VisualDBSerializer.class.getClassLoader());
	}
	
}
