/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CounterImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.RGBColorImpl;
import com.steadystate.css.dom.RectImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.LexicalUnitImpl;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSValueImpl
implements CSSPrimitiveValue,
CSSValueList,
Serializable {
    private Object _value = null;

    public CSSValueImpl(LexicalUnit lexicalUnit, boolean bl) {
        if (lexicalUnit.getParameters() != null) {
            this._value = lexicalUnit.getLexicalUnitType() == 38 ? new RectImpl(lexicalUnit.getParameters()) : (lexicalUnit.getLexicalUnitType() == 27 ? new RGBColorImpl(lexicalUnit.getParameters()) : (lexicalUnit.getLexicalUnitType() == 25 ? new CounterImpl(false, lexicalUnit.getParameters()) : (lexicalUnit.getLexicalUnitType() == 26 ? new CounterImpl(true, lexicalUnit.getParameters()) : lexicalUnit)));
        } else if (bl || lexicalUnit.getNextLexicalUnit() == null) {
            this._value = lexicalUnit;
        } else {
            Vector<CSSValueImpl> vector = new Vector<CSSValueImpl>();
            LexicalUnit lexicalUnit2 = lexicalUnit;
            while (lexicalUnit2 != null) {
                if (lexicalUnit2.getLexicalUnitType() != 0 && lexicalUnit2.getLexicalUnitType() != 4) {
                    vector.addElement(new CSSValueImpl(lexicalUnit2, true));
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            }
            this._value = vector;
        }
    }

    public CSSValueImpl(LexicalUnit lexicalUnit) {
        this(lexicalUnit, false);
    }

    public String getCssText() {
        if (this.getCssValueType() == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = (Vector)this._value;
            LexicalUnit lexicalUnit = (LexicalUnit)((CSSValueImpl)vector.elementAt((int)0))._value;
            while (lexicalUnit != null) {
                stringBuffer.append(lexicalUnit.toString());
                LexicalUnit lexicalUnit2 = lexicalUnit;
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() == 0 || lexicalUnit.getLexicalUnitType() == 4 || lexicalUnit2.getLexicalUnitType() == 4) continue;
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        return this._value.toString();
    }

    public void setCssText(String string) throws DOMException {
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSValueImpl cSSValueImpl = (CSSValueImpl)cSSOMParser.parsePropertyValue(inputSource);
            this._value = cSSValueImpl._value;
        }
        catch (Exception exception) {
            throw new DOMExceptionImpl(12, 0, exception.getMessage());
        }
    }

    public short getCssValueType() {
        return this._value instanceof Vector ? (short)2 : 1;
    }

    public short getPrimitiveType() {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lexicalUnit = (LexicalUnit)this._value;
            switch (lexicalUnit.getLexicalUnitType()) {
                case 12: {
                    return 21;
                }
                case 13: 
                case 14: {
                    return 1;
                }
                case 15: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 17: {
                    return 5;
                }
                case 18: {
                    return 8;
                }
                case 19: {
                    return 6;
                }
                case 20: {
                    return 7;
                }
                case 21: {
                    return 9;
                }
                case 22: {
                    return 10;
                }
                case 23: {
                    return 2;
                }
                case 24: {
                    return 20;
                }
                case 28: {
                    return 11;
                }
                case 29: {
                    return 13;
                }
                case 30: {
                    return 12;
                }
                case 31: {
                    return 14;
                }
                case 32: {
                    return 15;
                }
                case 33: {
                    return 17;
                }
                case 34: {
                    return 16;
                }
                case 35: {
                    return 21;
                }
                case 36: {
                    return 19;
                }
                case 37: {
                    return 22;
                }
                case 39: 
                case 40: 
                case 41: {
                    return 19;
                }
                case 42: {
                    return 18;
                }
            }
        } else {
            if (this._value instanceof RectImpl) {
                return 24;
            }
            if (this._value instanceof RGBColorImpl) {
                return 25;
            }
            if (this._value instanceof CounterImpl) {
                return 23;
            }
        }
        return 0;
    }

    public void setFloatValue(short s, float f) throws DOMException {
        this._value = LexicalUnitImpl.createNumber(null, f);
    }

    public float getFloatValue(short s) throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lexicalUnit = (LexicalUnit)this._value;
            return lexicalUnit.getFloatValue();
        }
        throw new DOMExceptionImpl(15, 10);
    }

    public void setStringValue(short s, String string) throws DOMException {
        switch (s) {
            case 19: {
                this._value = LexicalUnitImpl.createString(null, string);
                break;
            }
            case 20: {
                this._value = LexicalUnitImpl.createURI(null, string);
                break;
            }
            case 21: {
                this._value = LexicalUnitImpl.createIdent(null, string);
                break;
            }
            case 22: {
                throw new DOMExceptionImpl(9, 19);
            }
            default: {
                throw new DOMExceptionImpl(15, 11);
            }
        }
    }

    public String getStringValue() throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lexicalUnit = (LexicalUnit)this._value;
            if (lexicalUnit.getLexicalUnitType() == 35 || lexicalUnit.getLexicalUnitType() == 36 || lexicalUnit.getLexicalUnitType() == 24 || lexicalUnit.getLexicalUnitType() == 37) {
                return lexicalUnit.getStringValue();
            }
        } else if (this._value instanceof Vector) {
            return null;
        }
        throw new DOMExceptionImpl(15, 11);
    }

    public Counter getCounterValue() throws DOMException {
        if (!(this._value instanceof Counter)) {
            throw new DOMExceptionImpl(15, 12);
        }
        return (Counter)this._value;
    }

    public Rect getRectValue() throws DOMException {
        if (!(this._value instanceof Rect)) {
            throw new DOMExceptionImpl(15, 13);
        }
        return (Rect)this._value;
    }

    public RGBColor getRGBColorValue() throws DOMException {
        if (!(this._value instanceof RGBColor)) {
            throw new DOMExceptionImpl(15, 14);
        }
        return (RGBColor)this._value;
    }

    public int getLength() {
        return this._value instanceof Vector ? ((Vector)this._value).size() : 0;
    }

    public CSSValue item(int n) {
        return this._value instanceof Vector ? (CSSValue)((Vector)this._value).elementAt(n) : null;
    }

    public String toString() {
        return this.getCssText();
    }
}

