/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor;

public class InnerJavaScriptAssistProcessor
extends JavaScriptAssistProcessor {
    private HTMLAssistProcessor processor = null;
    private static final String START_SEQ = "<script";
    private static final String END_SEQ = "</script>";

    public InnerJavaScriptAssistProcessor(HTMLAssistProcessor processor) {
        this.processor = processor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int endIndex;
        String source = viewer.getDocument().get();
        String subSource = source.substring(0, offset);
        int lastIndex = subSource.lastIndexOf(START_SEQ);
        if (lastIndex >= 0) {
            endIndex = source.indexOf(62, lastIndex);
            if (lastIndex <= offset && offset <= endIndex) {
                return this.processor.computeCompletionProposals(viewer, offset);
            }
        }
        if ((lastIndex = subSource.lastIndexOf("</")) >= 0) {
            endIndex = source.indexOf(62, lastIndex);
            if (lastIndex <= offset && offset <= endIndex) {
                return new ICompletionProposal[0];
            }
        }
        return super.computeCompletionProposals(viewer, offset);
    }

    protected String getSource(ITextViewer viewer) {
        StringBuffer sb = new StringBuffer();
        String source = viewer.getDocument().get();
        int lastIndex = 0;
        int index = 0;
        while ((index = source.indexOf(START_SEQ, lastIndex)) >= 0) {
            int tagEnd = source.indexOf(62, index);
            if (tagEnd >= 0) {
                sb.append(source.substring(lastIndex, tagEnd));
                int end = source.indexOf(END_SEQ, index);
                if (end >= 0) {
                    sb.append(source.substring(tagEnd + 1, end));
                    sb.append(this.makeSpace(END_SEQ.length()));
                    lastIndex = end;
                    continue;
                }
            }
            sb.append(this.makeSpace(index - lastIndex + START_SEQ.length()));
            lastIndex = index + START_SEQ.length();
        }
        return sb.toString();
    }

    private String makeSpace(int length) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }
}

