/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class FoldingInfo {
    private int start;
    private int end;
    private String type;

    public FoldingInfo(int start) {
        this(start, -1, null);
    }

    public FoldingInfo(int start, int end) {
        this(start, end, null);
    }

    public FoldingInfo(int start, String type) {
        this(start, -1, type);
    }

    public FoldingInfo(int start, int end, String type) {
        this.setStart(start);
        this.setEnd(end);
        this.setType(type);
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static int countUpLineDelimiter(String text, int pos) {
        char c1;
        int count = 0;
        if (text.length() - 1 > pos && ((c1 = text.charAt(pos)) == '\r' || c1 == '\n')) {
            ++count;
            if (c1 == '\r' && text.length() - 1 > pos + 1 && text.charAt(pos + 1) == '\n') {
                ++count;
            }
        }
        return count;
    }

    public static void applyModifiedAnnotations(ProjectionAnnotationModel model, List list) {
        Iterator ite = model.getAnnotationIterator();
        while (ite.hasNext()) {
            ProjectionAnnotation annotation = (ProjectionAnnotation)ite.next();
            Position pos = model.getPosition((Annotation)annotation);
            boolean remove = true;
            int i = 0;
            while (i < list.size()) {
                FoldingInfo info = (FoldingInfo)list.get(i);
                if (info.getStart() == pos.offset && info.getEnd() == pos.offset + pos.length) {
                    remove = false;
                    list.remove(info);
                    break;
                }
                ++i;
            }
            if (!remove) continue;
            model.removeAnnotation((Annotation)annotation);
        }
        int i = 0;
        while (i < list.size()) {
            FoldingInfo info = (FoldingInfo)list.get(i);
            Position pos = new Position(info.getStart(), info.getEnd() - info.getStart());
            model.addAnnotation((Annotation)new ProjectionAnnotation(), pos);
            ++i;
        }
    }
}

