/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class ImageView
extends ViewPart
implements ISelectionListener {
    private ArrayList imageList = new ArrayList();
    private ArrayList iconList = new ArrayList();
    private SashForm sash;
    private Table table;
    private ScaleableImageCanvas canvas;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getPage().addSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.updateView(selection);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.sash.dispose();
        super.dispose();
    }

    private void updateView(ISelection selection) {
        this.table.removeAll();
        this.canvas.setImage(null);
        int i = 0;
        while (i < this.imageList.size()) {
            ((Image)this.imageList.get(i)).dispose();
            ((Image)this.iconList.get(i)).dispose();
            ++i;
        }
        this.imageList.clear();
        this.iconList.clear();
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IContainer) {
                this.showContainer((IContainer)obj);
            } else if (obj instanceof IFile) {
                this.showContainer(((IFile)obj).getParent());
            } else if (obj instanceof IJavaElement) {
                IResource resource = ((IJavaElement)obj).getResource();
                if (resource instanceof IContainer) {
                    this.showContainer((IContainer)resource);
                } else if (resource instanceof IFile) {
                    this.showContainer(((IFile)resource).getParent());
                }
            }
        }
    }

    private void showContainer(IContainer folder) {
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile) {
                    IFile file = (IFile)resources[i];
                    int j = 0;
                    while (j < HTMLPlugin.SUPPORTED_IMAGE_TYPES.length) {
                        if (file.getFileExtension().equalsIgnoreCase(HTMLPlugin.SUPPORTED_IMAGE_TYPES[j])) {
                            this.addImage(file);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addImage(IFile file) {
        try {
            ImageData data = new ImageData(file.getLocation().makeAbsolute().toFile().getAbsolutePath());
            Image image = new Image((Device)Display.getDefault(), data);
            Image i = new Image((Device)Display.getDefault(), 32, 32);
            GC gc = new GC((Drawable)i);
            gc.drawImage(image, 0, 0, image.getImageData().width, image.getImageData().height, 0, 0, 32, 32);
            gc.dispose();
            TableItem item = new TableItem(this.table, 0);
            item.setImage(i);
            item.setText(String.valueOf(file.getName()) + " (" + image.getImageData().width + " * " + image.getImageData().height + ")");
            this.imageList.add(image);
            this.iconList.add(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createPartControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        this.table = new Table((Composite)this.sash, 2048);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = ImageView.this.table.getSelectionIndex();
                if (index >= 0) {
                    ImageView.this.canvas.setImage((Image)ImageView.this.imageList.get(index));
                }
            }
        });
        Composite composite = new Composite((Composite)this.sash, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        CLabel label = new CLabel(composite, 0);
        label.setText(HTMLPlugin.getResourceString("ImageView.Preview"));
        label.setLayoutData((Object)new GridData(768));
        this.canvas = new ScaleableImageCanvas(composite, 2048);
        this.canvas.setLayoutData(new GridData(1808));
    }

    public void setFocus() {
        this.table.setFocus();
    }

    private class ScaleableImageCanvas
    extends Canvas {
        private Image image;
        private int width;
        private int height;
        private int ix = 0;
        private int iy = 0;

        public ScaleableImageCanvas(Composite parent, int style) {
            super(parent, style);
            this.setBackground(Display.getCurrent().getSystemColor(1));
            this.addPaintListener(new PaintListener(this){
                final /* synthetic */ ScaleableImageCanvas this$1;
                {
                    this.this$1 = scaleableImageCanvas;
                }

                public void paintControl(PaintEvent e) {
                    if (ScaleableImageCanvas.access$0(this.this$1) == null) {
                        e.gc.fillRectangle(0, 0, this.this$1.getSize().x, this.this$1.getSize().y);
                        return;
                    }
                    int scaledWidth = this.this$1.getSize().x;
                    int scaledHeight = this.this$1.getSize().y;
                    if (ScaleableImageCanvas.access$1(this.this$1) <= scaledWidth && ScaleableImageCanvas.access$2(this.this$1) <= scaledHeight) {
                        scaledWidth = ScaleableImageCanvas.access$1(this.this$1);
                        scaledHeight = ScaleableImageCanvas.access$2(this.this$1);
                    } else {
                        double scale = (double)scaledWidth / (double)ScaleableImageCanvas.access$1(this.this$1);
                        if ((double)ScaleableImageCanvas.access$2(this.this$1) * scale <= (double)scaledHeight) {
                            scaledHeight = (int)((double)ScaleableImageCanvas.access$2(this.this$1) * scale);
                        } else {
                            scale = (double)scaledHeight / (double)ScaleableImageCanvas.access$2(this.this$1);
                            scaledWidth = (int)((double)ScaleableImageCanvas.access$1(this.this$1) * scale);
                        }
                    }
                    e.gc.drawImage(ScaleableImageCanvas.access$0(this.this$1), 0, 0, ScaleableImageCanvas.access$1(this.this$1), ScaleableImageCanvas.access$2(this.this$1), ScaleableImageCanvas.access$3(this.this$1), ScaleableImageCanvas.access$4(this.this$1), scaledWidth, scaledHeight);
                }
            });
        }

        public void setImage(Image image) {
            this.image = image;
            if (image != null) {
                this.width = image.getImageData().width;
                this.height = image.getImageData().height;
            }
            this.redraw();
        }

        public void dispose() {
            super.dispose();
        }

        static /* synthetic */ Image access$0(ScaleableImageCanvas scaleableImageCanvas) {
            return scaleableImageCanvas.image;
        }

        static /* synthetic */ int access$1(ScaleableImageCanvas scaleableImageCanvas) {
            return scaleableImageCanvas.width;
        }

        static /* synthetic */ int access$2(ScaleableImageCanvas scaleableImageCanvas) {
            return scaleableImageCanvas.height;
        }

        static /* synthetic */ int access$3(ScaleableImageCanvas scaleableImageCanvas) {
            return scaleableImageCanvas.ix;
        }

        static /* synthetic */ int access$4(ScaleableImageCanvas scaleableImageCanvas) {
            return scaleableImageCanvas.iy;
        }
    }
}

