/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;

public class JavaScriptLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IFile) {
            try {
                IFile file = (IFile)element;
                ILaunchConfiguration config = this.getLaunchConfiguration(file);
                config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                ILaunchConfiguration config = this.getLaunchConfiguration(file);
                config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
    }

    private ILaunchConfiguration getLaunchConfiguration(IFile file) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations();
        String fullPath = file.getLocation().toFile().getAbsolutePath();
        int i = 0;
        while (i < configs.length) {
            String value = configs[i].getAttribute("javascript.file", "");
            if (value.equals(fullPath)) {
                return configs[i];
            }
            ++i;
        }
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("tk.eclipse.plugin.jseditor.launch.JavaScriptLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, manager.generateUniqueLaunchConfigurationNameFrom(file.getName()));
        wc.setAttribute("javascript.file", fullPath);
        try {
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String[] javaScripts = params.getJavaScripts();
            ArrayList<String> includes = new ArrayList<String>();
            int i2 = 0;
            while (i2 < javaScripts.length) {
                includes.add(javaScripts[i2]);
                ++i2;
            }
            wc.setAttribute("javascript.includes", includes);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        return wc.doSave();
    }
}

