/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jspeditor.compiler.CompileResult;
import tk.eclipse.plugin.jspeditor.compiler.JSPCompiler;
import tk.eclipse.plugin.jspeditor.editors.JSPSourceEditor;

public class JSPScriptletAssistProcessor
implements IContentAssistProcessor {
    private IFile file;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.file == null) {
            return new ICompletionProposal[0];
        }
        try {
            CompileResult result = JSPCompiler.compile(viewer.getDocument().get());
            IJavaProject project = JavaCore.create((IProject)this.file.getProject());
            if (project != null) {
                ICompilationUnit unit = HTMLUtil.getTemporaryCompilationUnit(project);
                HTMLUtil.setContentsToCU(unit, result.toString());
                CompletionProposalCollector collector = new CompletionProposalCollector(project);
                int headerLength = result.getHeader().length();
                unit.codeComplete(headerLength + offset, (CompletionRequestor)collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                IJavaCompletionProposal[] proposals = collector.getJavaCompletionProposals();
                ArrayList<AbstractJavaCompletionProposal> list = new ArrayList<AbstractJavaCompletionProposal>();
                int i = 0;
                while (i < proposals.length) {
                    AbstractJavaCompletionProposal proposal;
                    if (proposals[i] instanceof AbstractJavaCompletionProposal && !(proposal = (AbstractJavaCompletionProposal)proposals[i]).getDisplayString().endsWith("_xxx")) {
                        proposal.setReplacementOffset(proposal.getReplacementOffset() - headerLength);
                        list.add(proposal);
                    }
                    ++i;
                }
                return list.toArray(new ICompletionProposal[list.size()]);
            }
        }
        catch (Exception e) {
            HTMLPlugin.logException(e);
        }
        return new ICompletionProposal[0];
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        ContextInformation[] info = new ContextInformation[]{};
        return info;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    public String getErrorMessage() {
        return "Error";
    }

    public void update(JSPSourceEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)input).getFile();
        }
    }
}

