/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class HTMLOutlinePage
extends ContentOutlinePage
implements IHTMLOutlinePage {
    private RootNode root;
    private HTMLSourceEditor editor;
    private FuzzyXMLDocument doc;
    static /* synthetic */ Class class$0;

    public HTMLOutlinePage(HTMLSourceEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.root = new RootNode();
        viewer.setContentProvider((IContentProvider)new HTMLContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new HTMLLabelProvider());
        viewer.setInput((Object)this.root);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new HTMLSelectionChangedListener());
        try {
            viewer.setExpandedState(this.root.getChildren()[0], true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    protected boolean isHTML() {
        return true;
    }

    public void update() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.doc = new FuzzyXMLParser(this.isHTML()).parse(this.editor.getHTMLSource());
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.refresh();
        }
    }

    protected Image getNodeImage(FuzzyXMLNode element) {
        if (element instanceof FuzzyXMLElement) {
            FuzzyXMLElement e = (FuzzyXMLElement)element;
            if (e.getName().equalsIgnoreCase("html")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_html");
            }
            if (e.getName().equalsIgnoreCase("title")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_title");
            }
            if (e.getName().equalsIgnoreCase("body")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_body");
            }
            if (e.getName().equalsIgnoreCase("form")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_form");
            }
            if (e.getName().equalsIgnoreCase("img")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_image");
            }
            if (e.getName().equalsIgnoreCase("a")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_link");
            }
            if (e.getName().equalsIgnoreCase("table")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_table");
            }
            if (e.getName().equalsIgnoreCase("input")) {
                String type = e.getAttributeValue("type");
                if (type != null) {
                    if (type.equalsIgnoreCase("button") || type.equalsIgnoreCase("reset") || type.equalsIgnoreCase("submit")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_button");
                    }
                    if (type.equalsIgnoreCase("radio")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_radio");
                    }
                    if (type.equalsIgnoreCase("checkbox")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_check");
                    }
                    if (type.equalsIgnoreCase("text")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_text");
                    }
                    if (type.equalsIgnoreCase("password")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_pass");
                    }
                    if (type.equalsIgnoreCase("hidden")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_hidden");
                    }
                }
            } else {
                if (e.getName().equalsIgnoreCase("select")) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_select");
                }
                if (e.getName().equalsIgnoreCase("textarea")) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_textarea");
                }
            }
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
        }
        if (element instanceof FuzzyXMLDocType) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_doctype");
        }
        if (element instanceof FuzzyXMLComment) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_comment");
        }
        return null;
    }

    protected Object[] getNodeChildren(FuzzyXMLElement element) {
        ArrayList<FuzzyXMLNode> children = new ArrayList<FuzzyXMLNode>();
        FuzzyXMLNode[] nodes = element.getChildren();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                children.add(nodes[i]);
            } else if (nodes[i] instanceof FuzzyXMLDocType) {
                children.add(nodes[i]);
            } else if (nodes[i] instanceof FuzzyXMLComment) {
                children.add(nodes[i]);
            }
            ++i;
        }
        return children.toArray(new FuzzyXMLNode[children.size()]);
    }

    protected String getNodeText(FuzzyXMLNode node) {
        if (node instanceof FuzzyXMLElement) {
            StringBuffer sb = new StringBuffer();
            FuzzyXMLAttribute[] attrs = ((FuzzyXMLElement)node).getAttributes();
            int i = 0;
            while (i < attrs.length) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(attrs[i].getName()) + "=" + attrs[i].getValue());
                ++i;
            }
            if (sb.length() == 0) {
                return ((FuzzyXMLElement)node).getName();
            }
            return String.valueOf(((FuzzyXMLElement)node).getName()) + "(" + sb.toString() + ")";
        }
        if (node instanceof FuzzyXMLDocType) {
            return "DOCTYPE";
        }
        if (node instanceof FuzzyXMLComment) {
            return "#comment";
        }
        return node.toString();
    }

    private class HTMLContentProvider
    implements ITreeContentProvider {
        private HTMLContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RootNode) {
                return ((RootNode)parentElement).getChildren();
            }
            if (parentElement instanceof FuzzyXMLElement) {
                return HTMLOutlinePage.this.getNodeChildren((FuzzyXMLElement)parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof FuzzyXMLNode) {
                FuzzyXMLNode parent = ((FuzzyXMLNode)element).getParentNode();
                if (parent == null) {
                    return HTMLOutlinePage.this.root.getChildren()[0];
                }
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HTMLLabelProvider
    extends LabelProvider {
        private HTMLLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof FuzzyXMLNode) {
                return HTMLOutlinePage.this.getNodeImage((FuzzyXMLNode)element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FuzzyXMLNode) {
                return HTMLOutlinePage.this.getNodeText((FuzzyXMLNode)element);
            }
            return super.getText(element);
        }
    }

    private class HTMLSelectionChangedListener
    implements ISelectionChangedListener {
        private HTMLSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object element = sel.getFirstElement();
            if (element instanceof FuzzyXMLNode) {
                int offset = ((FuzzyXMLNode)element).getOffset();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart instanceof HTMLEditor) {
                    ((HTMLEditor)editorPart).setOffset(offset);
                } else if (editorPart instanceof HTMLSourceEditor) {
                    ((HTMLSourceEditor)editorPart).selectAndReveal(offset, 0);
                } else {
                    HTMLSourceEditor editor;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((editor = (HTMLSourceEditor)((Object)editorPart.getAdapter((Class)clazz))) != null) {
                        editor.selectAndReveal(offset, 0);
                    }
                }
            }
        }
    }

    private class RootNode {
        public Object[] getChildren() {
            ArrayList<Object> children = new ArrayList<Object>();
            if (HTMLOutlinePage.this.doc == null) {
                HTMLOutlinePage.this.update();
            }
            if (HTMLOutlinePage.this.doc.getDocumentType() != null) {
                children.add(HTMLOutlinePage.this.doc.getDocumentType());
            }
            FuzzyXMLNode[] nodes = HTMLOutlinePage.this.doc.getDocumentElement().getChildren();
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] instanceof FuzzyXMLElement) {
                    children.add(nodes[i]);
                }
                ++i;
            }
            return children.toArray(new FuzzyXMLNode[children.size()]);
        }

        public boolean equals(Object obj) {
            return obj instanceof RootNode;
        }
    }
}

