/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.template.HTMLTemplateAssistProcessor;
import tk.eclipse.plugin.htmleditor.template.HTMLTemplateManager;
import tk.eclipse.plugin.htmleditor.template.JavaScriptContextType;
import tk.eclipse.plugin.jseditor.editors.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.JavaScriptElement;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFunction;
import tk.eclipse.plugin.jseditor.editors.JavaScriptModel;
import tk.eclipse.plugin.jseditor.editors.JavaScriptVariable;
import tk.eclipse.plugin.jseditor.editors.additional.AdditionalJavaScriptCompleterManager;
import tk.eclipse.plugin.jseditor.editors.additional.IAdditionalJavaScriptCompleter;

public class JavaScriptAssistProcessor
extends HTMLTemplateAssistProcessor {
    private static List staticAssistInfo = new ArrayList();
    public static final int VARIABLE = 0;
    public static final int FUNCTION = 1;
    public static final int KEYWORD = 2;
    public static final int OBJECT = 3;
    public static final int UNDEF = 99;
    private static final String[] GLOBAL_PROPERTIES = new String[]{"Infinity", "NaN", "undefined"};
    private static final String[] GLOBAL_FUNCTIONS = new String[]{"decodeURI()", "decodeURIComponent()", "encodeURI()", "encodeURIComponent()", "escape()", "unescape()", "eval()", "isNaN()", "parseFloat()", "parseInt()", "taint()", "untaint()", "alert()"};
    private static final String[] CLASSES = new String[]{"Arguments", "Array", "Boolean", "Date", "Error", "Function", "Math", "NativeError", "Number", "Object", "RegExp", "String"};
    private static Map STATIC_MEMBERS = new HashMap();
    private List completers = new ArrayList();
    private List functions = new ArrayList();

    static {
        staticAssistInfo.add(new AssistInfo(0, "window"));
        staticAssistInfo.add(new AssistInfo(0, "document"));
        staticAssistInfo.add(new AssistInfo(0, "navigator"));
        staticAssistInfo.add(new AssistInfo(0, "history"));
        staticAssistInfo.add(new AssistInfo(0, "screen"));
        staticAssistInfo.add(new AssistInfo(0, "location"));
        int i = 0;
        while (i < GLOBAL_PROPERTIES.length) {
            staticAssistInfo.add(new AssistInfo(0, GLOBAL_PROPERTIES[i], GLOBAL_PROPERTIES[i].length()));
            ++i;
        }
        i = 0;
        while (i < GLOBAL_FUNCTIONS.length) {
            staticAssistInfo.add(new AssistInfo(1, GLOBAL_FUNCTIONS[i], GLOBAL_FUNCTIONS[i].length() - 1));
            ++i;
        }
        i = 0;
        while (i < CLASSES.length) {
            staticAssistInfo.add(new AssistInfo(3, CLASSES[i], CLASSES[i], CLASSES[i].length()));
            ++i;
        }
        AssistInfo[] math = new AssistInfo[]{new AssistInfo(0, "E - Math", "E"), new AssistInfo(0, "LN10 - Math", "LN10"), new AssistInfo(0, "LN2 - Math", "LN2"), new AssistInfo(0, "LOG10E - Math", "LOG10E"), new AssistInfo(0, "LOG2E - Math", "LOG2E"), new AssistInfo(0, "PI - Math", "PI"), new AssistInfo(0, "SQRT1_2 - Math", "SQRT1_2"), new AssistInfo(0, "SQRT2 - Math", "SQRT2"), new AssistInfo(1, "abs() - Math", "abs()"), new AssistInfo(1, "acos() - Math", "acos()"), new AssistInfo(1, "asin() - Math", "asin()"), new AssistInfo(1, "atan() - Math", "atan()"), new AssistInfo(1, "atan2() - Math", "atan2()"), new AssistInfo(1, "ceil() - Math", "ceil()"), new AssistInfo(1, "cos() - Math", "cos()"), new AssistInfo(1, "exp() - Math", "exp()"), new AssistInfo(1, "floor() - Math", "floor()"), new AssistInfo(1, "log() - Math", "log()"), new AssistInfo(1, "max() - Math", "max()"), new AssistInfo(1, "min() - Math", "min()"), new AssistInfo(1, "pow() - Math", "pow()"), new AssistInfo(1, "random() - Math", "random()"), new AssistInfo(1, "round() - Math", "round()"), new AssistInfo(1, "sin() - Math", "sin()"), new AssistInfo(1, "sqrt() - Math", "sqrt()"), new AssistInfo(1, "tan() - Math", "tan()")};
        STATIC_MEMBERS.put("Math", math);
        AssistInfo[] object = new AssistInfo[]{new AssistInfo(0, "constructor - Object", "constructor"), new AssistInfo(0, "prototype - Object", "prototype"), new AssistInfo(1, "hasOwnProperty() - Object", "hasOwnProperty()"), new AssistInfo(1, "hasOwnProperty() - Object", "hasOwnProperty()"), new AssistInfo(1, "isPrototyprOf() - Object", "isPrototyprOf()"), new AssistInfo(1, "propertyIsEnumerable() - Object", "propertyIsEnumerable()"), new AssistInfo(1, "toLocaleString() - Object", "toLocaleString()"), new AssistInfo(1, "toSource() - Object", "toSource()"), new AssistInfo(1, "toString() - Object", "toString()"), new AssistInfo(1, "unwatch() - Object", "unwatch()"), new AssistInfo(1, "valueOf() - Object", "valueOf()"), new AssistInfo(1, "watch() - Object", "watch()")};
        STATIC_MEMBERS.put("Object", object);
        AssistInfo[] element = new AssistInfo[]{new AssistInfo(0, "style - Element", "style"), new AssistInfo(0, "firstChild - Element", "firstChild"), new AssistInfo(0, "lastChild - Element", "lastChild"), new AssistInfo(0, "id - Element", "id"), new AssistInfo(0, "className - Element", "className"), new AssistInfo(0, "nextSibling - Element", "nextSibling"), new AssistInfo(0, "offsetHeight - Element", "offsetHeight"), new AssistInfo(0, "offsetLeft - Element", "offsetLeft"), new AssistInfo(0, "offsetTop - Element", "offsetTop"), new AssistInfo(0, "offsetWidth - Element", "offsetWidth"), new AssistInfo(0, "parentNode - Element", "parentNode"), new AssistInfo(0, "previousSibling - Element", "previousSibling"), new AssistInfo(1, "appendChild() - Element", "appendChild()"), new AssistInfo(1, "cloneNode() - Element", "cloneNode()"), new AssistInfo(1, "getAttribute() - Element", "getAttribute()"), new AssistInfo(1, "hasChildNodes() - Element", "hasChildNodes()"), new AssistInfo(1, "insertBefore() - Element", "insertBefore()"), new AssistInfo(1, "removeAttribute() - Element", "removeAttribute()"), new AssistInfo(1, "removeChild() - Element", "removeChild()"), new AssistInfo(1, "setAttribute() - Element", "setAttribute()")};
        STATIC_MEMBERS.put("Element", element);
        AssistInfo[] document = new AssistInfo[]{new AssistInfo(1, "createElement() - document", "createElement()"), new AssistInfo(1, "getElementById() - document", "getElementById()"), new AssistInfo(1, "getElementsByName() - document", "getElementsByName()"), new AssistInfo(1, "getElementsByTagName() - document", "getElementsByTagName()"), new AssistInfo(0, "alinkColor - document", "alinkColor"), new AssistInfo(0, "bgColor - document", "bgColor"), new AssistInfo(0, "cookie - document", "cookie"), new AssistInfo(0, "defaultCharset - document", "defaultCharset"), new AssistInfo(0, "domain - document", "domain"), new AssistInfo(0, "fgColor - document", "fgColor"), new AssistInfo(0, "fileCreatedDate - document", "fileCreatedDate"), new AssistInfo(0, "fileModifiedDate - document", "fileModifiedDate"), new AssistInfo(0, "fileSize - document", "fileSize"), new AssistInfo(0, "lastMofified - document", "lastMofified"), new AssistInfo(0, "linkColor - document", "linkColor"), new AssistInfo(0, "readyState - document", "readyState"), new AssistInfo(0, "referrer - document", "referrer"), new AssistInfo(0, "title - document", "title"), new AssistInfo(0, "URL - document", "URL"), new AssistInfo(0, "vlinkColor - document", "vlinkColor"), new AssistInfo(1, "clear() - document", "clear()"), new AssistInfo(1, "close() - document", "close()"), new AssistInfo(1, "getSelection() - document", "getSelection()"), new AssistInfo(1, "open() - document", "open()"), new AssistInfo(1, "routeEvent() - document", "routeEvent()"), new AssistInfo(1, "write() - document", "write()"), new AssistInfo(1, "writeln() - document", "writeln()")};
        STATIC_MEMBERS.put("document", document);
        AssistInfo[] style = new AssistInfo[]{new AssistInfo(0, "background"), new AssistInfo(0, "backgroundAttachment"), new AssistInfo(0, "backgroundColor"), new AssistInfo(0, "backgroundImage"), new AssistInfo(0, "backgroundPosition"), new AssistInfo(0, "backgroundRepeat"), new AssistInfo(0, "border"), new AssistInfo(0, "borderBottom"), new AssistInfo(0, "borderBottomColor"), new AssistInfo(0, "borderBottomStyle"), new AssistInfo(0, "borderBottomWidth"), new AssistInfo(0, "borderColor"), new AssistInfo(0, "borderLeft"), new AssistInfo(0, "borderLeftColor"), new AssistInfo(0, "borderLeftStyle"), new AssistInfo(0, "borderLeftWidth"), new AssistInfo(0, "borderRight"), new AssistInfo(0, "borderRightColor"), new AssistInfo(0, "borderRightStyle"), new AssistInfo(0, "borderRightWidth"), new AssistInfo(0, "borderStyle"), new AssistInfo(0, "borderTop"), new AssistInfo(0, "borderTopColor"), new AssistInfo(0, "borderTopStyle"), new AssistInfo(0, "borderTopWidth"), new AssistInfo(0, "clear"), new AssistInfo(0, "clip"), new AssistInfo(0, "color"), new AssistInfo(0, "cursor"), new AssistInfo(0, "display"), new AssistInfo(0, "filter"), new AssistInfo(0, "font"), new AssistInfo(0, "fontFamily"), new AssistInfo(0, "fontSize"), new AssistInfo(0, "fontVariant"), new AssistInfo(0, "fontWeight"), new AssistInfo(0, "height"), new AssistInfo(0, "left"), new AssistInfo(0, "letterSpacing"), new AssistInfo(0, "lineHeight"), new AssistInfo(0, "lineStyle"), new AssistInfo(0, "lineStyleImage"), new AssistInfo(0, "lineStylePosition"), new AssistInfo(0, "lineStyleType"), new AssistInfo(0, "margin"), new AssistInfo(0, "marginBottom"), new AssistInfo(0, "marginLeft"), new AssistInfo(0, "marginRight"), new AssistInfo(0, "marginTop"), new AssistInfo(0, "overflow"), new AssistInfo(0, "padding"), new AssistInfo(0, "paddingBottom"), new AssistInfo(0, "paddingLeft"), new AssistInfo(0, "paddingRight"), new AssistInfo(0, "paddingTop"), new AssistInfo(0, "pageBreakAfter"), new AssistInfo(0, "pageBreakBefore"), new AssistInfo(0, "position"), new AssistInfo(0, "styleFloat"), new AssistInfo(0, "textAlign"), new AssistInfo(0, "textDecoration"), new AssistInfo(0, "textDecorationBlink"), new AssistInfo(0, "textDecorationLineThrough"), new AssistInfo(0, "textDecorationNone"), new AssistInfo(0, "textDecorationOverline"), new AssistInfo(0, "textDecorationUnderline"), new AssistInfo(0, "textIndent"), new AssistInfo(0, "textTransform"), new AssistInfo(0, "top"), new AssistInfo(0, "verticalAlign"), new AssistInfo(0, "visibility"), new AssistInfo(0, "whiteSpace"), new AssistInfo(0, "width"), new AssistInfo(0, "wordBreak"), new AssistInfo(0, "wordWrap"), new AssistInfo(0, "zIndex")};
        STATIC_MEMBERS.put("style", style);
        AssistInfo[] window = new AssistInfo[]{new AssistInfo(0, "location - window", "location"), new AssistInfo(0, "history - window", "history"), new AssistInfo(0, "document - window", "document")};
        STATIC_MEMBERS.put("window", window);
        AssistInfo[] history = new AssistInfo[]{new AssistInfo(0, "length - history", "length"), new AssistInfo(1, "back() - history", "back()"), new AssistInfo(1, "forward() - history", "forward()"), new AssistInfo(1, "go() - history", "go()")};
        STATIC_MEMBERS.put("history", history);
        AssistInfo[] location = new AssistInfo[]{new AssistInfo(0, "hash - location", "hash"), new AssistInfo(0, "host - location", "host"), new AssistInfo(0, "hostname - location", "hostname"), new AssistInfo(0, "href - location", "href"), new AssistInfo(0, "port - location", "port"), new AssistInfo(0, "protocol - location", "protocol"), new AssistInfo(0, "search - location", "search"), new AssistInfo(1, "reload() - location", "reload()"), new AssistInfo(1, "replace() - location", "replace()")};
        STATIC_MEMBERS.put("location", location);
        AssistInfo[] screen = new AssistInfo[]{new AssistInfo(0, "colorDepth - screen", "colorDepth"), new AssistInfo(0, "fontSmoothingEnabled - screen", "fontSmoothingEnabled"), new AssistInfo(0, "height - screen", "height"), new AssistInfo(0, "updateInterval - screen", "updateInterval"), new AssistInfo(0, "width - screen", "width")};
        STATIC_MEMBERS.put("screen", screen);
    }

    protected String getSource(ITextViewer viewer) {
        return viewer.getDocument().get();
    }

    private AssistInfo[] getStatisMembers(String object) {
        ArrayList<AssistInfo> result = new ArrayList<AssistInfo>();
        AssistInfo[] info = (AssistInfo[])STATIC_MEMBERS.get(object);
        if (info != null) {
            int i = 0;
            while (i < info.length) {
                result.add(info[i]);
                ++i;
            }
        }
        if (object.equals("Object")) {
            AssistInfo[] elementInfo = (AssistInfo[])STATIC_MEMBERS.get("Element");
            int i = 0;
            while (i < elementInfo.length) {
                result.add(elementInfo[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < this.completers.size()) {
            IAdditionalJavaScriptCompleter completer = (IAdditionalJavaScriptCompleter)this.completers.get(i);
            AssistInfo[] additionalInfo = (AssistInfo[])completer.getClassAssistInformations().get(object);
            if (additionalInfo != null) {
                int j = 0;
                while (j < additionalInfo.length) {
                    result.add(additionalInfo[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new AssistInfo[result.size()]);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Object info;
        ArrayList<Object> proposal = new ArrayList<Object>();
        String source = this.getSource(viewer);
        String[] words = this.getLastWord(viewer, offset);
        String last = words[0];
        String word = words[1];
        ArrayList<String> addedStrings = new ArrayList<String>();
        if (last.endsWith(".")) {
            String objName = last.substring(0, last.length() - 1);
            info = this.getStatisMembers(objName);
            if (info == null && !this.isNumeric(objName)) {
                info = this.getStatisMembers("Object");
            }
            if (info != null) {
                int i = 0;
                while (i < ((AssistInfo[])info).length) {
                    if (((AssistInfo)info[i]).replaceString.startsWith(word)) {
                        proposal.add(((AssistInfo)info[i]).createCompletionProposal(offset, word));
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < staticAssistInfo.size()) {
                info = (AssistInfo)staticAssistInfo.get(i);
                if (((AssistInfo)info).replaceString.startsWith(word)) {
                    proposal.add(((AssistInfo)info).createCompletionProposal(offset, word));
                }
                ++i;
            }
            i = 0;
            while (i < this.completers.size()) {
                IAdditionalJavaScriptCompleter completer = (IAdditionalJavaScriptCompleter)this.completers.get(i);
                AssistInfo[] prototypeAssistInfo = completer.getGlobalAssistInformations();
                int j = 0;
                while (j < prototypeAssistInfo.length) {
                    if (prototypeAssistInfo[j].replaceString.startsWith(word)) {
                        proposal.add(prototypeAssistInfo[j].createCompletionProposal(offset, word));
                    }
                    ++j;
                }
                ++i;
            }
            JavaScriptModel model = new JavaScriptModel(source);
            JavaScriptContext context = model.getContextFromOffset(offset);
            if (context != null) {
                JavaScriptElement[] children = context.getVisibleElements();
                int i2 = 0;
                while (i2 < children.length) {
                    if (children[i2].getName().startsWith(word)) {
                        int type = 99;
                        int position = 0;
                        String replace = null;
                        if (children[i2] instanceof JavaScriptFunction) {
                            type = 1;
                            replace = String.valueOf(children[i2].getName()) + "()";
                            position = ((JavaScriptFunction)children[i2]).getArguments().length() == 0 ? replace.length() : replace.length() - 1;
                        } else if (children[i2] instanceof JavaScriptVariable) {
                            type = 0;
                            replace = children[i2].getName();
                            position = replace.length();
                        }
                        if (!addedStrings.contains(replace)) {
                            proposal.add(new CompletionProposal(replace, offset - word.length(), word.length(), position, JavaScriptAssistProcessor.getImageFromType(type), children[i2].toString(), null, null));
                            addedStrings.add(replace);
                        }
                    }
                    ++i2;
                }
            }
        }
        int i = 0;
        while (i < this.functions.size()) {
            info = (AssistInfo)this.functions.get(i);
            if (((AssistInfo)info).replaceString.startsWith(word) && !addedStrings.contains(((AssistInfo)info).replaceString)) {
                proposal.add(((AssistInfo)info).createCompletionProposal(offset, word));
                addedStrings.add(((AssistInfo)info).replaceString);
            }
            ++i;
        }
        ICompletionProposal[] templates = super.computeCompletionProposals(viewer, offset);
        int i3 = 0;
        while (i3 < templates.length) {
            proposal.add(templates[i3]);
            ++i3;
        }
        HTMLUtil.sortCompilationProposal(proposal);
        ICompletionProposal[] prop = proposal.toArray(new ICompletionProposal[proposal.size()]);
        return prop;
    }

    private static Image getImageFromType(int type) {
        switch (type) {
            case 2: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_value");
            }
            case 0: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_variable");
            }
            case 1: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_function");
            }
            case 3: {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_class");
            }
        }
        return null;
    }

    private boolean isNumeric(String value) {
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String[] getLastWord(ITextViewer viewer, int offset) {
        String source = viewer.getDocument().get();
        source = source.substring(0, offset);
        String last = "";
        int start = source.lastIndexOf(10);
        if (start == -1) {
            start = source.lastIndexOf(13);
        }
        if (start == -1) {
            start = 0;
        }
        StringBuffer sb = new StringBuffer();
        int i = start;
        while (i < offset) {
            char c = source.charAt(i);
            if (Character.isWhitespace(c) || !Character.isJavaIdentifierPart(c)) {
                if (sb.length() != 0) {
                    if (c == '.') {
                        sb.append(c);
                    }
                    last = sb.toString();
                    sb.setLength(0);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return new String[]{last, sb.toString()};
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public String getErrorMessage() {
        return "error";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        HTMLTemplateManager manager = HTMLTemplateManager.getInstance();
        return manager.getContextTypeRegistry().getContextType(JavaScriptContextType.CONTEXT_TYPE);
    }

    public void update(IFile file) {
        try {
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String[] names = params.getJavaScriptCompleters();
            this.completers.clear();
            int i = 0;
            while (i < names.length) {
                IAdditionalJavaScriptCompleter completer = AdditionalJavaScriptCompleterManager.getAdditionalJavaSCriptCompleter(names[i]);
                this.completers.add(completer);
                ++i;
            }
            String[] javaScripts = params.getJavaScripts();
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            this.functions.clear();
            int i2 = 0;
            while (i2 < javaScripts.length) {
                block11: {
                    int j = 0;
                    while (j < this.completers.size()) {
                        IAdditionalJavaScriptCompleter completer = (IAdditionalJavaScriptCompleter)this.completers.get(j);
                        if (!completer.isLibraryScriptFile(javaScripts[i2])) {
                            ++j;
                            continue;
                        }
                        break block11;
                    }
                    InputStream in = null;
                    if (javaScripts[i2].startsWith("entry:")) {
                        IResource resource = wsroot.findMember(javaScripts[i2].substring("entry:".length()));
                        if (resource != null && resource instanceof IFile && resource.exists()) {
                            in = ((IFile)resource).getContents();
                        }
                    } else {
                        in = new FileInputStream(javaScripts[i2]);
                    }
                    String source = new String(HTMLUtil.readStream(in));
                    JavaScriptModel model = new JavaScriptModel(source);
                    JavaScriptElement[] elements = model.getChildren();
                    int j2 = 0;
                    while (j2 < elements.length) {
                        if (elements[j2] instanceof JavaScriptFunction) {
                            String replace = String.valueOf(elements[j2].getName()) + "()";
                            int position = 0;
                            position = ((JavaScriptFunction)elements[j2]).getArguments().length() == 0 ? replace.length() : replace.length() - 1;
                            this.functions.add(new AssistInfo(1, elements[j2].toString(), replace, position));
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public static class AssistInfo {
        private int type;
        private int position;
        private String displayString;
        private String replaceString;

        public AssistInfo(int type, String string) {
            this(type, string, string);
        }

        public AssistInfo(int type, String string, int position) {
            this(type, string, string, position);
        }

        public AssistInfo(int type, String displayString, String replaceString) {
            this(type, displayString, replaceString, replaceString.endsWith("()") ? replaceString.length() - 1 : replaceString.length());
        }

        public AssistInfo(int type, String displayString, String replaceString, int position) {
            this.type = type;
            this.displayString = displayString;
            this.replaceString = replaceString;
            this.position = position;
        }

        public CompletionProposal createCompletionProposal(int offset, String word) {
            return new CompletionProposal(this.replaceString, offset - word.length(), word.length(), this.position, JavaScriptAssistProcessor.getImageFromType(this.type), this.displayString, null, null);
        }
    }
}

