/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class JavaScriptAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    protected boolean enable;

    public JavaScriptAutoEditStrategy() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        this.enable = store.getBoolean("__pref_auto_edit");
    }

    public void setEnabled(boolean enable) {
        this.enable = enable;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (this.enable) {
            if (command.text.equals("{")) {
                this.append(command, "}", 1);
                return;
            }
            if (command.text.equals("(")) {
                this.append(command, ")", 1);
                return;
            }
            if (command.text.equals("\"")) {
                this.append(command, "\"", 1);
                return;
            }
            if (command.text.equals("'")) {
                this.append(command, "'", 1);
                return;
            }
            try {
                if (command.text.equals("*") && command.offset > 0 && document.getChar(command.offset - 1) == '/') {
                    this.append(command, "  */", 2);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.customizeDocumentCommand(document, command);
    }

    private void append(DocumentCommand command, String append, int position) {
        command.text = String.valueOf(command.text) + append;
        command.doit = false;
        command.shiftsCaret = false;
        command.caretOffset = command.offset + position;
    }
}

