package net.java.amateras.xlsbeans.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

import jxl.Sheet;
import net.java.amateras.xlsbeans.NeedPostProcess;
import net.java.amateras.xlsbeans.Utils;
import net.java.amateras.xlsbeans.annotation.Cell;
import net.java.amateras.xlsbeans.xml.AnnotationReader;

/**
 * The {@link net.java.amateras.xlsbeans.processor.FieldProcessor} 
 * inplementation for {@link net.java.amateras.xlsbeans.annotation.Cell}.
 * 
 * @author Naoki Takezoe
 * @see net.java.amateras.xlsbeans.annotation.Cell
 */
public class CellProcessor implements FieldProcessor {

	public void doProcess(Sheet sheet, Object obj, 
			Method setter, Annotation ann, AnnotationReader reader,
			List<NeedPostProcess> needPostProcess) throws Exception {
		
		Cell cell = (Cell)ann;
		jxl.Cell jxlCell = sheet.getCell(cell.column(), cell.row());
		Utils.invokeSetter(setter, obj, jxlCell.getContents());
	}

}
