package net.java.amateras.xlsbeans;

import java.util.List;

import net.java.amateras.xlsbeans.annotation.HorizontalRecords;
import net.java.amateras.xlsbeans.annotation.LabelledCell;
import net.java.amateras.xlsbeans.annotation.LabelledCellType;
import net.java.amateras.xlsbeans.annotation.Sheet;

@Sheet(name="IDE")
public class IDEList {
	
	private String title = null;
	private List<IDE> ides;

	public String getTitle() {
		return title;
	}

	@LabelledCell(label="Title", optional=true, type=LabelledCellType.Right)
	public void setTitle(String title) {
		this.title = title;
	}
	
	public List<IDE> getIDEs() {
		return ides;
	}

	@HorizontalRecords(tableLabel="Java IDEs", recordClass=IDE.class)
	public void setIDEs(List<IDE> ides) {
		this.ides = ides;
	}
	
}
