package net.java.amateras.xlsbeans;

import java.util.List;

import junit.framework.TestCase;
import net.java.amateras.xlsbeans.sandbox.DumpXLSBeans;

/**
 * 
 * @author Naoki Takezoe
 */
public class XLSBeansTest extends TestCase {
	
	public void test1() throws Exception {
		
		System.out.println("*************************************");
		System.out.println("test1");
		System.out.println("*************************************");
		
		UserList userList = new XLSBeans().load(
				XLSBeansTest.class.getResourceAsStream("example_1.xls"),
				XLSBeansTest.class.getResourceAsStream("example_1.xml"),
				UserList.class);
		
		DumpXLSBeans.showDump(userList);
		
		assertEquals("User list2", userList.getTitle());
		assertEquals("06/04/10", userList.getLastUpdate());
		
		//////////////////////////////////////////////////////////
		List<User> hUsers = userList.getHorizontalUsers();
		assertEquals(4, hUsers.size());
		
		assertEquals(1, hUsers.get(0).getId());
		assertEquals("male", hUsers.get(0).getGender());
		assertEquals("Ken", hUsers.get(0).getName());
		assertEquals("Edgar", hUsers.get(0).getFamilyName());
		
		assertEquals(2, hUsers.get(1).getId());
		assertEquals("male", hUsers.get(1).getGender());
		assertEquals("John", hUsers.get(1).getName());
		assertEquals("Woodgate", hUsers.get(1).getFamilyName());
		
		assertEquals(3, hUsers.get(2).getId());
		assertEquals("male", hUsers.get(2).getGender());
		assertEquals("Mat", hUsers.get(2).getName());
		assertEquals("Brown", hUsers.get(2).getFamilyName());
		
		assertEquals(4, hUsers.get(3).getId());
		assertEquals("female", hUsers.get(3).getGender());
		assertEquals("Nancy", hUsers.get(3).getName());
		assertEquals("Davis", hUsers.get(3).getFamilyName());
		
		//////////////////////////////////////////////////////////
		List<User> vUsers = userList.getVerticalUsers();
		assertEquals(4, vUsers.size());
		
		assertEquals(1, vUsers.get(0).getId());
		assertEquals("male", vUsers.get(0).getGender());
		assertEquals("Ken", vUsers.get(0).getName());
		assertEquals("Edgar", vUsers.get(0).getFamilyName());
		
		assertEquals(2, vUsers.get(1).getId());
		assertEquals("", vUsers.get(1).getGender());
		assertEquals("John", vUsers.get(1).getName());
		assertEquals("Woodgate", vUsers.get(1).getFamilyName());
		
		assertEquals(3, vUsers.get(2).getId());
		assertEquals("", vUsers.get(2).getGender());
		assertEquals("Mat", vUsers.get(2).getName());
		assertEquals("Brown", vUsers.get(2).getFamilyName());
		
		assertEquals(4, vUsers.get(3).getId());
		assertEquals("female", vUsers.get(3).getGender());
		assertEquals("Nancy", vUsers.get(3).getName());
		assertEquals("Davis", vUsers.get(3).getFamilyName());
		
		//////////////////////////////////////////////////////////
		assertEquals("sample.SampleAction", userList.getActionClassName());
		assertEquals("sample.SampleForm", userList.getFormClassName());
	}
	
	public void test2() throws Exception {
		UserList[] userLists = new XLSBeans().loadMultiple(
				XLSBeansTest.class.getResourceAsStream("example_1.xls"),
				XLSBeansTest.class.getResourceAsStream("example_1.xml"),
				UserList.class);
		
		System.out.println("*************************************");
		System.out.println("test2");
		System.out.println("*************************************");
		
		for(UserList userList : userLists){
			DumpXLSBeans.showDump(userList);
//			System.out.println("--");
//			System.out.println("Title="+userList.getTitle());
//			System.out.println("LastUpdated="+userList.getLastUpdate());
//			
//			System.out.println("- Horizontal Table");
//			
//			for(User user : userList.getHorizontalUsers()){
//				System.out.println(user.toString());
//			}
//			
//			System.out.println("- Vertical Table");
//			
//			for(User user : userList.getVerticalUsers()){
//				System.out.println(user.toString());
//			}
		}
	}
	
	public void test3() throws Exception {
		Object[] objList = new XLSBeans().loadMultiple(
				XLSBeansTest.class.getResourceAsStream("example_2.xls"),
				null,
				new Class<?>[]{ LanguageList.class, IDEList.class});
		
		System.out.println("*************************************");
		System.out.println("test3");
		System.out.println("*************************************");
		
		for(Object obj : objList){
			DumpXLSBeans.showDump(obj);
		}
	}
	
	public static void main(String[] args) throws Exception {
		XLSBeansTest example = new XLSBeansTest();
		example.test1();
		example.test2();
		example.test3();
	}
	
}
