package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.List;

import jp.aonir.fuzzyxml.FuzzyXMLElement;

import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.IOUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;

/**
 * Provides completion proposals for the attribute value of Struts taglibs.
 * 
 * @author Naoki Takezoe
 */
public class StrutsAttributeAssist implements ICustomTagAttributeAssist {
	
	private Image actionImage;
	private Image forwardImage;
	private IFileAssistProcessor[] hrefAssistProcessor;
	
	public StrutsAttributeAssist(){
		actionImage  = StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_ACTION);
		forwardImage = StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_FORWARD);
		hrefAssistProcessor = HTMLPlugin.getDefault().getFileAssistProcessors();
	}
	
	public AssistInfo[] getAttributeValues(String tagName, String uri, String value,
			AttributeInfo attrInfo, FuzzyXMLElement element) {
		try {
			// TODO It should check also URI...
			if(!getFile().getProject().hasNature(StrutsPlugin.STRUTS_PROJECT_NATURE)){
				return null;
			}
			
			String attrName = attrInfo.getAttributeName();
			String type = StrutsTagDefinition.getAttributeInfo(tagName,attrName);
			
			if(type==null){
				return null;
				
			} else if(type==StrutsTagDefinition.ACTION){
				return getActionProposals();
				
			} else if(type==StrutsTagDefinition.HREF){
				return getHrefProposals(value);
				
			} else if(type==StrutsTagDefinition.FORWARD){
				return getForwardProposals();
			
			} else if(type==StrutsTagDefinition.FORM_NAME){
				return getFormNameProposals();
			
			} else if(type==StrutsTagDefinition.FORM_PROPERTY){
				return getFormPropertyProposals(element);
			}
		} catch(Exception ex){
			// Ignore
		}
		return null;
	}

	/**
	 * Returns completion porposals for <code>StrutsTagDefinition.FORWARD</code>.
	 */
	private AssistInfo[] getForwardProposals() {
		// forward attribute
		Document doc = getStrutsConfigDocument();
		ArrayList list = new ArrayList();
		JXPathContext ctx = JXPathContext.newContext(doc);
		List nodes = ctx.selectNodes("/struts-config/global-forwards/forward");
		for(int i=0;i<nodes.size();i++){
			Element forward = (Element)nodes.get(i);
			Attr attr = forward.getAttributeNode("name");
			if(attr!=null){
				list.add(new AssistInfo(attr.getValue(),forwardImage));
			}
		}
		return (AssistInfo[])list.toArray(new AssistInfo[list.size()]);
	}

	/**
	 * Returns completion porposals for <code>StrutsTagDefinition.FORM_PROPERTY</code>.
	 */
	private AssistInfo[] getFormPropertyProposals(FuzzyXMLElement element) {
		String formName = element.getAttributeValue("name");
		ArrayList list = new ArrayList();
		if(formName==null){
			// get formname from the action definition in the struts-config.xml
			FuzzyXMLElement formElement = getFormElement(element);
			if(formElement != null){
				String actionName = formElement.getAttributeValue("action");
				
				Document doc = getStrutsConfigDocument();
				JXPathContext ctx = JXPathContext.newContext(doc);
				List nodes = ctx.selectNodes("/struts-config/action-mappings/action");
				for(int i=0;i<nodes.size();i++){
					Element action = (Element)nodes.get(i);
					Attr attr = action.getAttributeNode("path");
					if(attr!=null && attr.getValue().equals(actionName)){
						Attr name = action.getAttributeNode("name");
						if(name != null){
							formName = name.getValue();
						}
						break;
					}
				}
			}
		}
		
		// retrieve form properties
		if(formName != null){
			StrutsProject project = new StrutsProject(getFile().getProject());
			String[] moduleNames = project.getModuleNames();
			MODULE_LOOP : for(int i=0;i<moduleNames.length;i++){
				FormInfo[] forms = project.getActionForms(moduleNames[i]);
				for(int j=0;j<forms.length;j++){
					if(forms[j].getFormName().equals(formName)){
						PropertyInfo[] props = forms[j].getProperties();
						for(int k=0;k<props.length;k++){
							if(!props[k].getPropertyType().startsWith("org.apache")){
								list.add(new AssistInfo(props[k].getPropertyName(),
										props[k].getPropertyName() + " - " + props[k].getPropertyType(),
										StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_PROPERTY)));
							}
						}
						break MODULE_LOOP;
					}
				}
			}
		}
		
		return (AssistInfo[])list.toArray(new AssistInfo[list.size()]);
	}

	/**
	 * Returns completion porposals for <code>StrutsTagDefinition.FORM_NAME</code>.
	 */
	private AssistInfo[] getFormNameProposals() {
		StrutsProject project = new StrutsProject(getFile().getProject());
		String[] moduleNames = project.getModuleNames();
		ArrayList list = new ArrayList();
		for(int i=0;i<moduleNames.length;i++){
			FormInfo[] forms = project.getActionForms(moduleNames[i]);
			for(int j=0;j<forms.length;j++){
				String displayString = forms[j].getFormName();
				if(moduleNames[i]!=null && moduleNames[i].length()>0){
					displayString = displayString + "(" + moduleNames[i] + ")";
				}
				displayString = displayString + " - " + forms[j].getClassName();
				
				list.add(new AssistInfo(forms[j].getFormName(), displayString,
						StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_BEAN)));
			}
		}
		return (AssistInfo[])list.toArray(new AssistInfo[list.size()]);
	}

	/**
	 * Returns completion porposals for <code>StrutsTagDefinition.HREF</code>.
	 */
	private AssistInfo[] getHrefProposals(String value) {
		// href attribute
		IFile file = getFile();
		ArrayList list = new ArrayList();
		for(int i=0;i<hrefAssistProcessor.length;i++){
			hrefAssistProcessor[i].reload(file);
			AssistInfo[] info = hrefAssistProcessor[i].getAssistInfo(value);
			for(int j=0;j<info.length;j++){
				list.add(info[j]);
			}
		}
		return (AssistInfo[])list.toArray(new AssistInfo[list.size()]);
	}
	
	/**
	 * Returns completion porposals for <code>StrutsTagDefinition.ACTION</code>.
	 */
	private AssistInfo[] getActionProposals() {
		Document doc = getStrutsConfigDocument();
		ArrayList list = new ArrayList();
		JXPathContext ctx = JXPathContext.newContext(doc);
		List nodes = ctx.selectNodes("/struts-config/action-mappings/action");
		for(int i=0;i<nodes.size();i++){
			Element action = (Element)nodes.get(i);
			Attr attr = action.getAttributeNode("path");
			if(attr!=null){
				list.add(new AssistInfo(attr.getValue(),actionImage));
			}
		}
		return (AssistInfo[])list.toArray(new AssistInfo[list.size()]);
	}
	
	/////////////////////////////////////////////////////////////////////
	// Utilities
	
	private static FuzzyXMLElement getFormElement(FuzzyXMLElement element){
		while(true){
			element = (FuzzyXMLElement) element.getParentNode();
			if(element==null){
				break;
			}
			if(element.getName().endsWith(":form")){
				return element;
			}
		}
		return null;
	}
	
	private Document getStrutsConfigDocument(){
		try {
			IEditorPart editor = HTMLUtil.getActiveEditor();
			IProject project = ((IFileEditorInput)editor.getEditorInput()).getFile().getProject();
			HTMLProjectParams params = new HTMLProjectParams(project);
			IFile file = project.getFile(new Path(params.getRoot()).append("/WEB-INF/struts-config.xml"));
			if(file.exists()){
				Document doc = Util.createXMLDocument(new String(IOUtil.readStream(file.getContents())));
				return doc;
			}
		} catch(Exception ex){
			Util.logException(ex);
		}
		return null;
	}
	
	private IFile getFile(){
		IEditorPart editor = HTMLUtil.getActiveEditor();
		return ((IFileEditorInput)editor.getEditorInput()).getFile();
	}

}
