package tk.eclipse.plugin.struts;

import java.util.List;

import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;


/**
 * When model is modified, this class modify related parameters.
 * 
 * @author Naoki Takezoe
 */
public class StrutsConfigRefactor {
    
    /**
     * Call this method when the path of action or JSP was modified.
     * This method updates following attributes automatically.
     * <ul>
     *   <li>a path attribute of a global-forward element</li>
     *   <li>a path attribute of a global-exception element</li>
     *   <li>a input attribute of an action element</li>
     * </ul>
     * The property change event isn't fired while processing.
     * And if event firing isn't allowed, this method do nothing.
     */
    public static void changePath(RootModel root,String from,String to){
    	// Do nothing, if event firing is not allowed.
    	if(!StrutsPlugin.getDefault().canFirePropertyChangeEvent()){
    		return;
    	}
    	// The event firing is not allowed while processing Refactoring. 
    	StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
    	try {
	        List list = root.getChildren();
	        for(int i=0;i<list.size();i++){
	            Object obj = list.get(i);
	            if(obj instanceof ActionModel){
                    /* (MVL) not needed, as input is now a connection
	                ActionModel model = (ActionModel)obj;
	                String input = model.getInput();
	                if(!input.equals("") && input.equals(from)){
	                    model.setInput(to);
	                }
                    */
	            } else if(obj instanceof GlobalForwardModel){
	                GlobalForwardModel model = (GlobalForwardModel)obj;
	                String path = model.getPath();
	                if(!path.equals("") && path.equals(from)){
	                    model.setPath(to);
	                }
	            } else if(obj instanceof GlobalExceptionModel){
	                GlobalExceptionModel model = (GlobalExceptionModel)obj;
	                String path = model.getPath();
	                if(!path.equals("") && path.equals(from)){
	                    model.setPath(to);
	                }
	            }
	        }
    	} finally {
    		StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
    	}
    }
    
    /**
     * Call this method when the name attribute of action-form was modified.
     * This method updates following attributes automatically.
     * <ul>
     *   <li>a name attribute of an action element</li>
     * </ul>
     * The property change event isn't fired while processing.
     * And if event firing isn't allowed, this method do nothing.
     */
    public static void changeFormName(RootModel root,String from,String to){
    	// Do nothing, if event firing is not allowed.
    	if(!StrutsPlugin.getDefault().canFirePropertyChangeEvent()){
    		return;
    	}
    	// The event firing is not allowed while processing Refactoring. 
    	StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
    	try {
	        List list = root.getChildren();
	        for(int i=0;i<list.size();i++){
	            Object obj = list.get(i);
	            if(obj instanceof ActionModel){
	            	ActionModel model = (ActionModel)obj;
	            	String name = model.getName();
	            	if(!name.equals("") && name.equals(from)){
	            		model.setName(to);
	            	}
	            }
	        }
    	} finally {
    		StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
    	}
    }
}
