package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.jxpath.JXPathContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.IOUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;

public class StrutsFileAssistProcessor implements IFileAssistProcessor {
	
	private String extension;
	private String[] actions;
	
	public void reload(IFile file) {
		try {
			IProject project = file.getProject();
			if(!project.hasNature(StrutsPlugin.STRUTS_PROJECT_NATURE)){
				actions = new String[0];
				return;
			}
			StrutsProject strutsProject = new StrutsProject(project);
			this.extension = strutsProject.getExtension();
			
			// TODO This must be got from StrutsProject
			HTMLProjectParams params = new HTMLProjectParams(project);
			String root = params.getRoot();
			IPath path = new Path(root).append("/WEB-INF/struts-config.xml");
			IFile strutsConfig = project.getFile(path);
			ArrayList list = new ArrayList();
			if(strutsConfig.exists()){
				Document doc = Util.createXMLDocument(new String(IOUtil.readStream(strutsConfig.getContents())));
		        JXPathContext ctx = JXPathContext.newContext(doc);
				List nodes = ctx.selectNodes("/struts-config/action-mappings/action");
				for(int i=0;i<nodes.size();i++){
					Element element = (Element)nodes.get(i);
					Attr attr = element.getAttributeNode("path");
					if(attr!=null){
						String action = attr.getValue();
						if(action.startsWith("/")){
							action = action.substring(1);
						}
						list.add(action);
					}
				}
			}
			actions = (String[])list.toArray(new String[list.size()]);
		} catch(Exception ex){
			// Ignore
			//ex.printStackTrace();
			actions = new String[0];
		}
	}

	public AssistInfo[] getAssistInfo(String value) {
		AssistInfo[] assist = new AssistInfo[actions.length];
		for(int i=0;i<assist.length;i++){
			assist[i] = new AssistInfo(actions[i] + extension,StrutsPlugin.getDefault().getImage(StrutsPlugin.ICON_ACTION));
		}
		return assist;
	}

}
