package tk.eclipse.plugin.struts;

import java.util.ArrayList;

import org.eclipse.jface.resource.ImageDescriptor;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.views.DefaultPaletteItem;
import tk.eclipse.plugin.htmleditor.views.IPaletteContributer;
import tk.eclipse.plugin.htmleditor.views.IPaletteItem;
//import tk.eclipse.plugin.htmleditor.views.JSPTaglibPaletteItem;

public class StrutsHTMLPaletteContributer implements IPaletteContributer {

	public IPaletteItem[] getPaletteItems() {
		ArrayList list = new ArrayList();
		
		// form
		list.add(createItem("html:form",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_FORM),
				"<html:form />"));
		
		// button
		list.add(createItem("html:button",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_BUTTON),
				"<html:button />"));
		list.add(createItem("html:submit",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_BUTTON),
				"<html:submit />"));
//		list.add(createItem("html:cancel",
//				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_BUTTON),
//				"<html:cancel />"));
		list.add(createItem("html:reset",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_BUTTON),
				"<html:reset />"));
		
		// text
		list.add(createItem("html:text",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_TEXT),
				"<html:text />"));
		list.add(createItem("html:textarea",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_TEXTAREA),
				"<html:textarea />"));
		list.add(createItem("html:password",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_PASS),
				"<html:password />"));
		
		// etc
		list.add(createItem("html:checkbox",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_CHECK),
				"<html:checkbox />"));
		list.add(createItem("html:radio",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_RADIO),
				"<html:radio />"));
		list.add(createItem("html:select",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_SELECT),
				"<html:select />"));
		
		// message
		list.add(createItem("html:errors",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_LABEL),
				"<html:errors />"));
		list.add(createItem("html:messages",
				HTMLPlugin.getDefault().getImageRegistry().getDescriptor(HTMLPlugin.ICON_LABEL),
				"<html:messages />"));
		
		return (IPaletteItem[])list.toArray(new IPaletteItem[list.size()]);
	}

	private IPaletteItem createItem(String name,ImageDescriptor image,String content){
//		JSPTaglibPaletteItem item = new JSPTaglibPaletteItem(name,image,content);
		DefaultPaletteItem item = new DefaultPaletteItem(name,image,content);
//		item.addUri("/WEB-INF/struts-html.tld");
//		item.setPrefix("html");
		return item;
	}
	
}
