package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

/**
 * This class provides informations of the Struts project.
 * 
 * @author Naoki Takezoe
 */
public class StrutsProject {
	
	private IProject project;
	private IJavaProject javaProject;
	private Map modules = null;
	
	public StrutsProject(IProject project){
		this.project = project;
		this.javaProject = JavaCore.create(project);
	}
	
	private void initModuleInfo(){
		
		modules = new HashMap();
		
		try {
			HTMLProjectParams params = new HTMLProjectParams(project);
			IPath path = new Path(params.getRoot()).append("/WEB-INF/web.xml");
			IFile file = project.getFile(path);
			if(file!=null && file.exists()){
				FuzzyXMLDocument doc = new FuzzyXMLParser().parse(file.getContents());
				FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(doc.getDocumentElement(),
						"/web-app/servlet[servlet-name='action']/init-param");
				
				for(int i=0;i<nodes.length;i++){
					FuzzyXMLElement initParam = (FuzzyXMLElement)nodes[i];
					String name  = HTMLUtil.getXPathValue(initParam, "/param-name");
					String value = HTMLUtil.getXPathValue(initParam, "/param-value");
					if(name!=null && value!=null){
						if(name.trim().startsWith("config/")){
							modules.put(name.trim().substring(7), value.trim());
						} else if(name.trim().equals("config")){
							modules.put("", value.trim());
						}
					}
				}
			}
		} catch(Exception ex){
		}
	}
	
	/**
	 * Returns module names.
	 * 
	 * @return the array of module names
	 */
	public String[] getModuleNames(){
		if(modules==null){
			initModuleInfo();
		}
		return (String[])modules.keySet().toArray(new String[modules.size()]);
	}
	
	/**
	 * Returns configuration files of the specified module.
	 * 
	 * @param moduleName the module name
	 * @return the array of IFile
	 */
	public IFile[] getStrutsConfigXML(String moduleName){
		if(moduleName==null){
			moduleName = "";
		}
		if(modules==null){
			initModuleInfo();
		}
		try {
			String value = (String)modules.get(moduleName);
			if(value!=null){
				HTMLProjectParams params = new HTMLProjectParams(project);
				String[] names = value.split(",");
				ArrayList files = new ArrayList();
				for(int i=0;i<names.length;i++){
					IPath path = new Path(params.getRoot()).append(names[i].trim());
					IFile file = project.getFile(path);
					if(file!=null && file.exists()){
						files.add(file);
					}
				}
				return (IFile[])files.toArray(new IFile[files.size()]);
			}
		} catch(Exception ex){
		}
		return new IFile[0];
	}
	
	/**
	 * Returns the extension of the action path.
	 * 
	 * @return the extension of the action path like <code>&quot;.do&quot;</code>
	 */
	public String getExtension(){
		try {
			HTMLProjectParams params = new HTMLProjectParams(project);
			IPath path = new Path(params.getRoot()).append("/WEB-INF/web.xml");
			IFile file = project.getFile(path);
			if(file!=null && file.exists()){
				FuzzyXMLDocument doc = new FuzzyXMLParser().parse(file.getContents());
				String value = HTMLUtil.getXPathValue(doc.getDocumentElement(),
						"/web-app/servlet-mapping[servlet-name='action']/url-pattern");
				value = value.trim();
				if(value!=null && value.startsWith("*.")){
					return value.substring(1);
				}
			}
			
		} catch(Exception ex){
		}
		return ".do";
	}
	
	/**
	 * Returns configuration files of Tiles
	 * 
	 * @return the array of IFile.
	 */
	public IFile[] getTilesXML(String moduleName){
		if(moduleName==null){
			moduleName = "";
		}
		
		ArrayList tiles = new ArrayList();
		
		try {
			HTMLProjectParams params = new HTMLProjectParams(project);
		
			IFile[] files = getStrutsConfigXML(moduleName);
			for(int i=0;i<files.length;i++){
				try {
					FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
					FuzzyXMLNode node = HTMLUtil.selectXPathNode(doc.getDocumentElement(),
							"/struts-config/plug-in[@className='org.apache.struts.tiles.TilesPlugin']/set-property[@property='definitions-config']");
					if(node!=null){
						String value = ((FuzzyXMLElement)node).getAttributeNode("value").getValue();
						String[] dim = value.split(",");
						for(int j=0;j<dim.length;j++){
							IPath path = new Path(params.getRoot()).append(dim[j].trim());
							IFile file = project.getFile(path);
							if(file!=null && file.exists()){
								tiles.add(file);
							}
						}
					}
				} catch(Exception ex){
					Util.logException(ex);
				}
			}
		} catch(Exception ex){
			Util.logException(ex);
		}
		return (IFile[])tiles.toArray(new IFile[tiles.size()]);
	}
	
	/**
	 * Returns configuration files of Validator
	 * 
	 * @return the array of IFile.
	 */
	public IFile[] getValidatorXML(String moduleName){
		if(moduleName==null){
			moduleName = "";
		}
		
		ArrayList validators = new ArrayList();
		
		try {
			HTMLProjectParams params = new HTMLProjectParams(project);
		
			IFile[] files = getStrutsConfigXML(moduleName);
			for(int i=0;i<files.length;i++){
				try {
					FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
					FuzzyXMLNode node = HTMLUtil.selectXPathNode(doc.getDocumentElement(),
							"/struts-config/plug-in[@className='org.apache.struts.validator.ValidatorPlugIn']/set-property[@property='pathnames']");
					if(node!=null){
						String value = ((FuzzyXMLElement)node).getAttributeNode("value").getValue();
						String[] dim = value.split(",");
						for(int j=0;j<dim.length;j++){
							IPath path = new Path(params.getRoot()).append(dim[j].trim());
							IFile file = project.getFile(path);
							if(file!=null && file.exists()){
								validators.add(file);
							}
						}
					}
				} catch(Exception ex){
					Util.logException(ex);
				}
			}
		} catch(Exception ex){
			Util.logException(ex);
		}
		return (IFile[])validators.toArray(new IFile[validators.size()]);

	}
	
	/**
	 * Returns information of ActionForms
	 * 
	 * @return the array of FormInfo which contain information of ActionForms.
	 */
	public FormInfo[] getActionForms(String moduleName){
		if(moduleName==null){
			moduleName = "";
		}
		
		ArrayList formInfos = new ArrayList();
		IFile[] files = getStrutsConfigXML(moduleName);
		
		for(int i=0;i<files.length;i++){
			try {
				FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
				FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes(
						doc.getDocumentElement(),"//struts-config/form-beans/form-bean");
				for(int j=0;j<nodes.length;j++){
					try {
						FuzzyXMLElement element = (FuzzyXMLElement)nodes[j];
						String formName  = element.getAttributeNode("name").getValue();
						String clazzName = element.getAttributeNode("type").getValue();
						IType type = null;
						try {
							type = javaProject.findType(clazzName);
						} catch(JavaModelException ex){
						}
						FuzzyXMLNode[] props = HTMLUtil.selectXPathNodes(element,"/form-property");
						PropertyInfo[] dynaProperties = new PropertyInfo[props.length];
						for(int k=0;k<props.length;k++){
							dynaProperties[k] = new PropertyInfo(
									type,
									((FuzzyXMLElement)props[k]).getAttributeNode("name").getValue(),
									((FuzzyXMLElement)props[k]).getAttributeNode("type").getValue()
							);
						}
						if(type!=null){
							formInfos.add(new FormInfo(formName,type,dynaProperties));
						} else {
							formInfos.add(new FormInfo(formName,clazzName,dynaProperties));
						}
					} catch(Exception ex){
						// ignore
					}
				}
			} catch(Exception ex){
				Util.logException(ex);
			}			
		}
		return (FormInfo[])formInfos.toArray(new FormInfo[formInfos.size()]);
	}
	
	/**
	 * Tests whether the class denoted by the full classname exists. 
	 * 
	 * @param className fully qualified classname.
	 * @return true if the class which specified by an argument exists; false otherwise
	 */
	public boolean existsClass(String className){
		try {
			IType type = javaProject.findType(className);
			if(type.isClass() && type.exists()){
				return true;
			}
		} catch(Exception ex){
		}
		return false;
	}
	
	/**
	 * Returns definition names which defined in configuration files of Tiles.
	 * 
	 * @return the array of Tiles definition names.
	 */
	public String[] getTilesDefinition(String moduleName){
		if(moduleName==null){
			moduleName = "";
		}
		IFile[] files = getTilesXML(moduleName);
		ArrayList list = new ArrayList();
		for(int i=0;i<files.length;i++){
			try {
				FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
				FuzzyXMLNode[] nodes = XPath.selectNodes(doc.getDocumentElement(),"/tiles-definitions/definition");
				for(int j=0;j<nodes.length;j++){
					FuzzyXMLElement element = (FuzzyXMLElement)nodes[j];
					FuzzyXMLAttribute attr = element.getAttributeNode("name");
					if(attr!=null){
						list.add(attr.getValue());
					}
				}
			} catch(Exception ex){
				// failed to parse the Tiles configuration file.
			}
		}
		return (String[])list.toArray(new String[list.size()]);
	}
	
	/**
	 * Tests whether the JSP file denoted by the pathname  exists. 
	 * 
	 * @param path the path of the JSP file
	 * @param moduleName the module name
	 * @return true if the JSP file which specified by an argument exists; false otherwise
	 */
	public boolean existsJSP(String path, String moduleName){
		if(moduleName==null){
			moduleName = "";
		}
		try {
			HTMLProjectParams params = new HTMLProjectParams(project);
			if(path.indexOf("?") > 0){
				path = path.substring(0,path.indexOf("?"));
			}
			
			if(moduleName!=null && !moduleName.equals("")){
				if(!path.startsWith("/")){
					path = "/" + path;
				}
				path = "/" + moduleName + path;
			}
			
			IFile jsp = project.getFile(new Path(params.getRoot()).append(path));
			if(jsp!=null && jsp.exists()){
				return true;
			}
		} catch(Exception ex){
			Util.logException(ex);
		}
		return false;
	}
}
